/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.internal.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.internal.resource.EmfFacetResourceSet;
import org.eclipse.emf.facet.infra.common.core.internal.resource.IEmfFacetResourceListener;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;

public class EmfFacetResourceListenerGroup {
    private final Map<IEmfFacetResourceListener, HashSet<URI>> listeners = new HashMap<IEmfFacetResourceListener, HashSet<URI>>();
    private final URI watchedResourceUri;

    public EmfFacetResourceListenerGroup(URI watchedResourceUri) {
        this.watchedResourceUri = watchedResourceUri;
        if (EmfFacetResourceSet.DEBUG) {
            String message = String.valueOf(this.getClass().getSimpleName()) + "." + this.getClass().getSimpleName() + "(): " + this.watchedResourceUri;
            System.out.println(message);
        }
    }

    public void notifyChange() {
        if (EmfFacetResourceSet.DEBUG) {
            String message = String.valueOf(this.getClass().getSimpleName()) + ".notifyChange(): " + this.watchedResourceUri + " nbListeners=" + this.listeners.size();
            System.out.println(message);
        }
        ArrayList<1> toDoList = new ArrayList<1>();
        Iterator<IEmfFacetResourceListener> iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            IEmfFacetResourceListener iEmfFacetResourceListener;
            final IEmfFacetResourceListener fListener = iEmfFacetResourceListener = iterator.next();
            Iterator<URI> iterator2 = this.listeners.get(iEmfFacetResourceListener).iterator();
            while (iterator2.hasNext()) {
                URI clientUri;
                final URI fClientURI = clientUri = iterator2.next();
                Runnable toDo = new Runnable(){

                    public void run() {
                        try {
                            if (EmfFacetResourceSet.DEBUG) {
                                System.out.println(String.valueOf(EmfFacetResourceListenerGroup.this.getClass().getSimpleName()) + ".notifyChange(): aListenedResourceHasChanged(changed=" + EmfFacetResourceListenerGroup.this.watchedResourceUri + ", depending=" + fClientURI + ")");
                            }
                            fListener.aListenedResourceHasChanged(EmfFacetResourceListenerGroup.this.watchedResourceUri, fClientURI);
                        }
                        catch (Exception e) {
                            Logger.logError(e, "An exception happened while notifying change of: " + EmfFacetResourceListenerGroup.this.watchedResourceUri + " to: " + fListener, (Plugin)CommonEmfFacetActivator.getDefault());
                        }
                    }
                };
                toDoList.add(toDo);
            }
        }
        for (Runnable runnable : toDoList) {
            runnable.run();
        }
    }

    public void addListener(IEmfFacetResourceListener listener, URI resourceUri) {
        HashSet<Object> list = this.listeners.get(listener);
        if (list == null) {
            list = new HashSet();
            this.listeners.put(listener, list);
        }
        list.add(resourceUri);
    }

    public void remove(IEmfFacetResourceListener listener, URI dependingResource) {
        HashSet<URI> uriSet = this.listeners.get(listener);
        if (uriSet != null) {
            uriSet.remove(dependingResource);
        }
    }
}

