/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.treelayout.commands;

import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutConstraint;
import de.itemis.gmf.runtime.commons.treelayout.TreeLayoutUtil;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class UpdateAnnotationsOnMoveCommand
extends AbstractTransactionalCommand {
    private final IGraphicalEditPart editPart;
    private final TreeLayoutConstraint layoutConstraint;

    public UpdateAnnotationsOnMoveCommand(TransactionalEditingDomain editingDomain, IGraphicalEditPart editPart, TreeLayoutConstraint layoutConstraint) {
        super(editingDomain, "Move TreeNode", null);
        this.editPart = editPart;
        this.layoutConstraint = layoutConstraint;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList<IGraphicalEditPart> treeChildren;
        IGraphicalEditPart parentEditPart;
        View parentView = TreeLayoutUtil.getTreeNodeParentView(this.editPart.getNotationView());
        if (parentView != null && (parentEditPart = (IGraphicalEditPart)this.editPart.findEditPart(this.editPart.getParent(), parentView.getElement())) != null && !(treeChildren = new ArrayList<IGraphicalEditPart>(TreeLayoutUtil.getOrderedTreeChildren(parentEditPart))).isEmpty()) {
            int oldPos = treeChildren.indexOf(this.editPart);
            int newPos = this.layoutConstraint.getTreeInnerRankIndex();
            if (newPos != -1 && oldPos != newPos) {
                IGraphicalEditPart element = (IGraphicalEditPart)treeChildren.get(oldPos);
                treeChildren.remove(oldPos);
                treeChildren.add(newPos, element);
                TreeLayoutUtil.setTreeNodesPositionAnnotation(TreeLayoutUtil.getViews(treeChildren));
            }
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)"Parent view or parent edit part not found!");
    }
}

