/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.gmf.runtime.commons.editparts;

import de.itemis.gmf.runtime.commons.parsers.StringAttributeParser;
import de.itemis.xtext.utils.gmf.figures.HighlightingWrappingLabel;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Color;

public abstract class TextAwareExternalLabelEditPart
extends LabelEditPart
implements ITextAwareEditPart {
    private final DirectEditManager manager;
    private final EAttribute feature;
    private final String pluginId;

    public TextAwareExternalLabelEditPart(View view, EAttribute feature, String pluginId) {
        super(view);
        this.feature = feature;
        this.pluginId = pluginId;
        this.manager = this.createDirectEditManager();
    }

    private void updateLabelText() {
        this.getWrappingLabel().setText(this.getEditText());
    }

    public void activate() {
        super.activate();
        this.updateLabelText();
    }

    protected DirectEditManager createDirectEditManager() {
        return new TextDirectEditManager((ITextAwareEditPart)this);
    }

    public Object getAdapter(Class key) {
        if (key.equals(ILabelDelegate.class)) {
            WrappingLabel wrappingLabel = this.getWrappingLabel();
            if (wrappingLabel == null) {
                return super.getAdapter(key);
            }
            return new WrappingLabelDelegate(wrappingLabel);
        }
        return super.getAdapter(key);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFont();
        this.refreshFontColor();
    }

    protected void setFontColor(Color color) {
        this.getWrappingLabel().setForegroundColor(color);
    }

    public String getEditText() {
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.resolveSemanticElement()), -1);
    }

    public void setLabelText(String text) {
        this.getWrappingLabel().setText(text);
    }

    private WrappingLabel getWrappingLabel() {
        return (WrappingLabel)this.getFigure();
    }

    protected IFigure createFigure() {
        return new HighlightingWrappingLabel();
    }

    public ICellEditorValidator getEditTextValidator() {
        return null;
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        return new StringAttributeParser(this.feature, this.pluginId);
    }

    public IContentAssistProcessor getCompletionProcessor() {
        return null;
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (TextAwareExternalLabelEditPart.this.isActive()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character && TextAwareExternalLabelEditPart.this.manager instanceof TextDirectEditManager) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            ((TextDirectEditManager)TextAwareExternalLabelEditPart.this.manager).show(initialChar.charValue());
                        } else {
                            TextAwareExternalLabelEditPart.this.manager.show();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("parentview", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("parentview");
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getFeature() == this.feature) {
            this.updateLabelText();
        }
        if (event.getNotifier() instanceof ShapeStyle) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(event);
    }
}

