/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.editpolicy;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.widgets.editors.SelectionMenu;
import org.eclipse.papyrus.views.modelexplorer.Activator;

public class NavigationEditPolicy
extends GraphicalEditPolicy {
    public static final String EDIT_POLICY_ID = "org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationEditPolicy";
    private ViewerContext viewerContext;

    public void activate() {
        super.activate();
        this.initViewerContext();
        if (this.viewerContext == null) {
            return;
        }
    }

    private void initViewerContext() {
        if (this.getHost() == this.getRoot()) {
            EditPartViewer viewer = this.getHost().getViewer();
            this.viewerContext = new ViewerContext(viewer);
        } else {
            EditPolicy rootNavigationEditPolicy = this.getRoot().getEditPolicy((Object)EDIT_POLICY_ID);
            if (rootNavigationEditPolicy instanceof NavigationEditPolicy) {
                this.viewerContext = ((NavigationEditPolicy)rootNavigationEditPolicy).viewerContext;
            }
        }
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        if (this.viewerContext == null) {
            return;
        }
        if (this.getRoot() == this.getHost()) {
            return;
        }
        if (request instanceof SelectionRequest) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            this.viewerContext.handleRequest(selectionRequest);
        }
    }

    public Command getCommand(Request request) {
        if (request instanceof SelectionRequest && this.viewerContext != null) {
            return this.viewerContext.navigate((SelectionRequest)request);
        }
        return super.getCommand(request);
    }

    private EditPart getRoot() {
        RootEditPart rootEditPart = this.getHost().getRoot();
        return rootEditPart.getContents();
    }

    private class ViewerContext {
        private EditPartViewer editPartViewer;
        private EObject currentModel;
        private SelectionMenu selectionMenu;
        private boolean wasUnderlined;
        private WrappingLabel lastWrappingLabel;

        public void handleRequest(SelectionRequest request) {
            if (this.isExitState(request)) {
                this.exitItem();
            }
            if (this.isEnterState(request)) {
                this.enterItem(this.currentModel, request);
            }
        }

        public Command navigate(final SelectionRequest request) {
            if (!this.isAlt(request)) {
                return null;
            }
            final NavigableElement element = this.getElementToNavigate(request);
            if (element == null) {
                return null;
            }
            return new Command(){

                public void execute() {
                    try {
                        ViewerContext.this.getNavigationService(request).navigate(element);
                    }
                    catch (ServiceException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                    ViewerContext.this.exitItem();
                }
            };
        }

        private NavigableElement getElementToNavigate(SelectionRequest request) {
            List navigableElements;
            block4: {
                navigableElements = this.getNavigationService(request).getNavigableElements((Object)this.getEditPart(request));
                if (!navigableElements.isEmpty()) break block4;
                return null;
            }
            try {
                for (NavigableElement element : navigableElements) {
                    if (!element.isEnabled()) continue;
                    return element;
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            return null;
        }

        private NavigationService getNavigationService(SelectionRequest request) throws ServiceException {
            return (NavigationService)this.getServicesRegistry().getService(NavigationService.class);
        }

        public ViewerContext(EditPartViewer editPartViewer) {
            this.editPartViewer = editPartViewer;
        }

        private boolean isExitState(SelectionRequest request) {
            if (this.currentModel == null) {
                return false;
            }
            EObject newModel = this.getModel(request);
            if (newModel == null) {
                return true;
            }
            if (newModel != this.currentModel) {
                return true;
            }
            return !this.isAlt(request);
        }

        private boolean isEnterState(SelectionRequest request) {
            EObject model = this.getModel(request);
            if (model == this.currentModel) {
                return false;
            }
            if (model == null) {
                return false;
            }
            if (!this.isAlt(request)) {
                return false;
            }
            this.currentModel = model;
            return true;
        }

        private boolean isAlt(SelectionRequest request) {
            return request.isAltKeyPressed();
        }

        private EObject getModel(SelectionRequest request) {
            return EMFHelper.getEObject((Object)this.getEditPart(request));
        }

        private EditPart getEditPart(SelectionRequest request) {
            return this.editPartViewer.findObjectAt(request.getLocation());
        }

        private void disposeCurrentMenu() {
            if (this.selectionMenu != null) {
                this.selectionMenu.dispose();
                this.selectionMenu = null;
            }
        }

        private void exitItem() {
            if (this.lastWrappingLabel != null) {
                this.lastWrappingLabel.setTextUnderline(this.wasUnderlined);
            }
            this.wasUnderlined = false;
            this.lastWrappingLabel = null;
            this.currentModel = null;
            this.disposeCurrentMenu();
        }

        private void enterItem(EObject model, SelectionRequest request) {
            try {
                IGraphicalEditPart graphicalEditPart;
                IFigure figure;
                EditPart targetEditPart = this.getEditPart(request);
                final NavigationService navigation = (NavigationService)this.getServicesRegistry().getService(NavigationService.class);
                this.disposeCurrentMenu();
                this.selectionMenu = navigation.createNavigationList((Object)targetEditPart, this.editPartViewer.getControl());
                if (this.selectionMenu == null) {
                    return;
                }
                this.wasUnderlined = false;
                if (targetEditPart instanceof IGraphicalEditPart && (figure = (graphicalEditPart = (IGraphicalEditPart)targetEditPart).getFigure()) instanceof WrappingLabel) {
                    this.lastWrappingLabel = (WrappingLabel)figure;
                    this.wasUnderlined = this.lastWrappingLabel.isTextUnderlined();
                    this.lastWrappingLabel.setTextUnderline(!this.wasUnderlined);
                }
                this.selectionMenu.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection().isEmpty()) {
                            return;
                        }
                        Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (selectedElement instanceof NavigableElement) {
                            NavigableElement navigableElement = (NavigableElement)selectedElement;
                            ViewerContext.this.navigate(navigableElement, navigation);
                        }
                    }
                });
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }

        private void navigate(NavigableElement navigableElement, NavigationService navigationService) {
            navigationService.navigate(navigableElement);
            this.exitItem();
        }

        private ServicesRegistry getServicesRegistry() throws ServiceException {
            return ServiceUtilsForEditPart.getInstance().getServiceRegistry(NavigationEditPolicy.this.getHost());
        }
    }
}

