/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.papyrus.dsml.validation.wizard.Activator;
import org.eclipse.papyrus.dsml.validation.wizard.ClassesGenerator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaContentGenerator {
    protected List<IFile> files;
    protected Profile umlProfile;
    private IProject project;

    public JavaContentGenerator(IProject project, Profile umlProfile) {
        this.project = project;
        this.umlProfile = umlProfile;
    }

    public void run() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                URI modelURI = JavaContentGenerator.this.umlProfile.eResource().getURI();
                try {
                    IFolder target = JavaContentGenerator.this.project.getFolder("src");
                    Utils.setPluginID((String)JavaContentGenerator.this.project.getName());
                    ClassesGenerator generator = new ClassesGenerator(modelURI, (IContainer)target, JavaContentGenerator.this.getArguments());
                    generator.doGenerate(monitor);
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.papyrus.dsml.validation.wizard", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.papyrus.dsml.validation.wizard", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.papyrus.dsml.validation.wizard", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected List<? extends Object> getArguments() {
        return new ArrayList();
    }
}

