/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementList;
import org.eclipse.papyrus.uml.profile.ui.dialogs.IChooseDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.IListViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ChooseSetAssistedDialog
extends Dialog
implements IChooseDialog {
    protected static final int channel = 19;
    protected String possibleText = "Choose Element";
    protected String selectedText = "Selected Element(s)";
    protected Button addButton;
    protected Button removeButton;
    protected Button upButton;
    protected Button downButton;
    protected MouseListener addButtonListener = null;
    protected MouseListener deleteButtonListener = null;
    protected MouseListener upButtonListener = null;
    protected MouseListener downButtonListener = null;
    protected MouseListener addItemListener = null;
    protected MouseListener removeItemListener = null;
    protected KeyTextListener keyTextListener = null;
    protected Table possibleElementsTable;
    protected Table selectedElementsTable;
    protected TableViewer selectedElementsTableViewer;
    protected TableViewer possibleElementsTableViewer;
    protected LabelProvider labelProvider;
    protected DecoratedContentProposalProvider decoratedContentProposalProvider;
    protected ElementList selectedElementList = new ElementList();
    protected ElementList possibleElementList = new ElementList();
    protected Text possibleElementsText;
    protected Label possibleElementsLabel;
    protected Label selectedElementsLabel;
    private static final Image IMG_UP_ARROW = ImageManager.IMG_UP;
    private static final Image IMG_DOWN_ARROW = ImageManager.IMG_DOWN;
    private static final Image IMG_LEFT_ARROW = ImageManager.IMG_LEFT;
    private static final Image IMG_RIGHT_ARROW = ImageManager.IMG_RIGHT;
    protected Object value = null;

    public ChooseSetAssistedDialog(Shell parentShell, String possibleText, String selectedText) {
        super(parentShell);
        this.setShellStyle(0x10 | super.getShellStyle());
        if (possibleText != null) {
            this.possibleText = possibleText;
        }
        if (selectedText != null) {
            this.selectedText = selectedText;
        }
        this.addButtonListener = new AddButtonListener();
        this.deleteButtonListener = new RemoveButtonListener();
        this.upButtonListener = new UpButtonListener();
        this.downButtonListener = new DownButtonListener();
        this.addItemListener = new AddItemListener();
        this.removeItemListener = new RemoveItemListener();
        this.keyTextListener = new KeyTextListener();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        FormLayout layout = new FormLayout();
        comp.setLayout((Layout)layout);
        this.createElements(comp);
        this.setLayoutData();
        this.addButtonListeners();
        this.setFonts();
        this.setTableViewers();
        this.installContentAssistantProvider();
        return comp;
    }

    private void setTableViewers() {
        this.possibleElementsTableViewer = new TableViewer(this.possibleElementsTable);
        this.possibleElementsTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.possibleElementsTableViewer.setContentProvider((IContentProvider)new PossibleElementsContentProvider());
        this.possibleElementsTableViewer.setInput((Object)this.possibleElementList);
        this.selectedElementsTableViewer = new TableViewer(this.selectedElementsTable);
        this.selectedElementsTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.selectedElementsTableViewer.setContentProvider((IContentProvider)new SelectedElementsContentProvider());
        this.selectedElementsTableViewer.setInput((Object)this.selectedElementList);
    }

    private void createElements(Composite comp) {
        this.addButton = new Button(comp, 0x1000000);
        this.addButton.setImage(IMG_RIGHT_ARROW);
        this.removeButton = new Button(comp, 0x1000000);
        this.removeButton.setImage(IMG_LEFT_ARROW);
        this.upButton = new Button(comp, 0x1000000);
        this.upButton.setImage(IMG_UP_ARROW);
        this.downButton = new Button(comp, 0x1000000);
        this.downButton.setImage(IMG_DOWN_ARROW);
        this.possibleElementsLabel = new Label(comp, 0x1000000);
        this.possibleElementsLabel.setText(this.possibleText);
        this.selectedElementsLabel = new Label(comp, 0x1000000);
        this.selectedElementsLabel.setText(this.selectedText);
        this.possibleElementsTable = new Table(comp, 2562);
        this.possibleElementsTable.addMouseListener(this.addItemListener);
        this.selectedElementsTable = new Table(comp, 2562);
        this.selectedElementsTable.addMouseListener(this.removeItemListener);
        this.possibleElementsText = new Text(comp, 2048);
        this.possibleElementsText.addKeyListener((KeyListener)this.keyTextListener);
    }

    private void setFonts() {
        this.selectedElementsLabel.setFont(JFaceResources.getDialogFont());
        this.selectedElementsTable.setFont(JFaceResources.getDialogFont());
        this.possibleElementsLabel.setFont(JFaceResources.getDialogFont());
        this.possibleElementsTable.setFont(JFaceResources.getDialogFont());
    }

    private void setLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 4);
        data.left = new FormAttachment(0, 5);
        this.possibleElementsLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(40, 0);
        data.right = new FormAttachment(50, -2);
        this.addButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.addButton, 4, 1024);
        data.right = new FormAttachment(50, -2);
        this.removeButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)this.addButton, -5);
        data.bottom = new FormAttachment(100, -4);
        this.possibleElementsText.setLayoutData((Object)data);
        data = new FormData();
        data.height = 200;
        data.width = 300;
        data.top = new FormAttachment((Control)this.possibleElementsLabel, 4);
        data.left = new FormAttachment(0, 5);
        data.bottom = new FormAttachment((Control)this.possibleElementsText, -4);
        data.right = new FormAttachment((Control)this.addButton, -5);
        this.possibleElementsTable.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.addButton, 5);
        this.selectedElementsLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.addButton, 5);
        data.top = new FormAttachment((Control)this.selectedElementsLabel, 4);
        data.right = new FormAttachment((Control)this.upButton, -5);
        data.bottom = new FormAttachment(100, -4);
        this.selectedElementsTable.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(40, 0);
        data.right = new FormAttachment(100, -5);
        this.upButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.upButton, 5, 1024);
        data.right = new FormAttachment(100, -5);
        this.downButton.setLayoutData((Object)data);
    }

    public void setFocus() {
        this.possibleElementsText.setFocus();
    }

    private void addButtonListeners() {
        this.addButton.addMouseListener(this.addButtonListener);
        this.removeButton.addMouseListener(this.deleteButtonListener);
        this.upButton.addMouseListener(this.upButtonListener);
        this.downButton.addMouseListener(this.downButtonListener);
    }

    protected void installContentAssistantProvider() {
        KeyStroke keyStroke = null;
        char[] autoActivationCharacters = null;
        int autoActivationDelay = 500;
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.possibleElementsText, (IControlContentAdapter)new TextContentAdapter(), this.getContentProposalProvider(), keyStroke, autoActivationCharacters);
        adapter.setAutoActivationDelay(autoActivationDelay);
        adapter.setFilterStyle(3);
        adapter.setProposalAcceptanceStyle(2);
        adapter.addContentProposalListener((IContentProposalListener)this.keyTextListener);
    }

    public Object getValue() {
        return this.value;
    }

    protected void runActionAdd() {
        IStructuredSelection selection = (IStructuredSelection)this.possibleElementsTableViewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.runActionAdd(it.next());
        }
    }

    public void runActionAdd(Object element) {
        this.possibleElementList.removeElement(element);
        this.selectedElementList.addElement(element);
    }

    protected void runActionRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsTableViewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.runActionRemove(it.next());
        }
    }

    protected void runActionRemove(Object element) {
        this.selectedElementList.removeElement(element);
        this.possibleElementList.addElement(element);
    }

    protected void runActionUp() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsTableViewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.runActionUp(it.next());
        }
    }

    protected void runActionUp(Object element) {
        this.selectedElementList.moveElementUp(element);
    }

    protected void runActionDown() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsTableViewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.runActionDown(it.next());
        }
    }

    protected void runActionDown(Object element) {
        this.selectedElementList.moveElementDown(element);
    }

    protected void runAddItem(TableItem item) {
        if (item != null) {
            this.runActionAdd(item.getData());
        }
    }

    protected void runRemoveItem(TableItem item) {
        if (item != null) {
            this.runActionRemove(item.getData());
        }
    }

    protected void runAddElement(String name) {
    }

    protected ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    protected IContentProposalProvider getContentProposalProvider() {
        if (this.decoratedContentProposalProvider == null) {
            this.decoratedContentProposalProvider = new DecoratedContentProposalProvider();
        }
        return this.decoratedContentProposalProvider;
    }

    protected boolean isSelectableElement(String text) {
        return false;
    }

    public ArrayList getSelectedElements() {
        return this.selectedElementList.getElements();
    }

    protected TableItem getItem(MouseEvent event) {
        TableItem[] items = ((Table)event.getSource()).getSelection();
        if (items.length > 0) {
            return items[0];
        }
        return null;
    }

    protected class AddButtonListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ChooseSetAssistedDialog.this.runActionAdd();
        }
    }

    protected class AddItemListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
            ChooseSetAssistedDialog.this.runAddItem(ChooseSetAssistedDialog.this.getItem(e));
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DecoratedContentProposal
    implements IContentProposal,
    Comparable<DecoratedContentProposal> {
        protected LabelProvider labelProvider;
        protected Object element;

        public DecoratedContentProposal(Object element, LabelProvider labelProvider) {
            this.labelProvider = labelProvider;
            this.element = element;
        }

        public String getContent() {
            return this.labelProvider.getText(this.element);
        }

        public int getCursorPosition() {
            return this.labelProvider.getText(this.element).length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.labelProvider.getText(this.element);
        }

        public Image getImage() {
            return this.labelProvider.getImage(this.element);
        }

        @Override
        public int compareTo(DecoratedContentProposal o) {
            return this.getLabel().compareTo(o.getLabel());
        }
    }

    protected class DecoratedContentProposalProvider
    implements IContentProposalProvider {
        protected DecoratedContentProposalProvider() {
        }

        public DecoratedContentProposal[] getProposals(String contents, int position) {
            return new DecoratedContentProposal[0];
        }
    }

    protected class DownButtonListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ChooseSetAssistedDialog.this.runActionDown();
        }
    }

    private class InputOperation
    implements IRunnableWithProgress {
        private InputOperation() {
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            ChooseSetAssistedDialog.this.possibleElementsTableViewer = new TableViewer(ChooseSetAssistedDialog.this.possibleElementsTable);
            ChooseSetAssistedDialog.this.possibleElementsTableViewer.setLabelProvider((IBaseLabelProvider)ChooseSetAssistedDialog.this.getLabelProvider());
            ChooseSetAssistedDialog.this.possibleElementsTableViewer.setContentProvider((IContentProvider)new PossibleElementsContentProvider());
            ChooseSetAssistedDialog.this.possibleElementsTableViewer.setInput((Object)ChooseSetAssistedDialog.this.possibleElementList);
            ChooseSetAssistedDialog.this.selectedElementsTableViewer = new TableViewer(ChooseSetAssistedDialog.this.selectedElementsTable);
            ChooseSetAssistedDialog.this.selectedElementsTableViewer.setLabelProvider((IBaseLabelProvider)ChooseSetAssistedDialog.this.getLabelProvider());
            ChooseSetAssistedDialog.this.selectedElementsTableViewer.setContentProvider((IContentProvider)new SelectedElementsContentProvider());
            ChooseSetAssistedDialog.this.selectedElementsTableViewer.setInput((Object)ChooseSetAssistedDialog.this.selectedElementList);
        }

        public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            final InvocationTargetException[] iteHolder = new InvocationTargetException[1];
            try {
                IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor pm) throws CoreException {
                        try {
                            InputOperation.this.execute(pm);
                        }
                        catch (InvocationTargetException e) {
                            iteHolder[0] = e;
                        }
                        catch (InterruptedException e) {
                            throw new OperationCanceledException(e.getMessage());
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceRunnable, monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            if (iteHolder[0] != null) {
                throw iteHolder[0];
            }
        }
    }

    protected class KeyTextListener
    implements KeyListener,
    IContentProposalListener {
        protected KeyTextListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 && ChooseSetAssistedDialog.this.isSelectableElement(ChooseSetAssistedDialog.this.possibleElementsText.getText())) {
                ChooseSetAssistedDialog.this.runAddElement(ChooseSetAssistedDialog.this.possibleElementsText.getText());
                ChooseSetAssistedDialog.this.possibleElementsText.setText("");
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void proposalAccepted(IContentProposal proposal) {
            if (ChooseSetAssistedDialog.this.isSelectableElement(proposal.getContent())) {
                ChooseSetAssistedDialog.this.runAddElement(proposal.getContent());
            }
        }
    }

    class PossibleElementsContentProvider
    implements IStructuredContentProvider,
    IListViewer {
        PossibleElementsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ElementList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ElementList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            ChooseSetAssistedDialog.this.possibleElementList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return ChooseSetAssistedDialog.this.possibleElementList.getElements().toArray();
        }

        public void addElement(Object element) {
            ChooseSetAssistedDialog.this.possibleElementsTableViewer.add(element);
        }

        public void removeElement(Object element) {
            ChooseSetAssistedDialog.this.possibleElementsTableViewer.remove(element);
        }

        public void updateElement(Object element) {
            ChooseSetAssistedDialog.this.possibleElementsTableViewer.refresh();
        }
    }

    protected class RemoveButtonListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ChooseSetAssistedDialog.this.runActionRemove();
        }
    }

    protected class RemoveItemListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
            ChooseSetAssistedDialog.this.runRemoveItem(ChooseSetAssistedDialog.this.getItem(e));
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    class SelectedElementsContentProvider
    implements IStructuredContentProvider,
    IListViewer {
        SelectedElementsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ElementList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ElementList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            ChooseSetAssistedDialog.this.selectedElementList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return ChooseSetAssistedDialog.this.selectedElementList.getElements().toArray();
        }

        public void addElement(Object element) {
            ChooseSetAssistedDialog.this.selectedElementsTableViewer.add(element);
        }

        public void removeElement(Object element) {
            ChooseSetAssistedDialog.this.selectedElementsTableViewer.remove(element);
        }

        public void updateElement(Object element) {
            ChooseSetAssistedDialog.this.selectedElementsTableViewer.refresh();
        }
    }

    protected class UpButtonListener
    implements MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ChooseSetAssistedDialog.this.runActionUp();
        }
    }
}

