/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.databinding;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFObservableList
extends ObservableList
implements ICommitListener,
IChangeListener,
IObserving {
    protected List<Command> commands = new LinkedList<Command>();
    protected EditingDomain editingDomain;
    protected EObject source;
    protected EStructuralFeature feature;
    protected List<?> concreteList;
    protected boolean isCommitting;

    public EMFObservableList(List<?> wrappedList, EditingDomain domain, EObject source, EStructuralFeature feature) {
        super(new LinkedList(wrappedList), Object.class);
        this.concreteList = wrappedList;
        this.editingDomain = domain;
        this.source = source;
        this.feature = feature;
        if (this.concreteList instanceof IObservableList) {
            ((IObservableList)this.concreteList).addChangeListener((IChangeListener)this);
        }
    }

    public void handleChange(ChangeEvent event) {
        if (this.isCommitting) {
            return;
        }
        if (this.commands.isEmpty()) {
            this.refreshCacheList();
        }
    }

    public Object getObserved() {
        return this.source;
    }

    public synchronized void dispose() {
        if (this.concreteList instanceof IObservableList) {
            ((IObservableList)this.concreteList).removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    public synchronized void commit(AbstractEditor editor) {
        this.isCommitting = true;
        if (this.commands.isEmpty()) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand(){

            public void execute() {
                super.execute();
                EMFObservableList.this.refreshCacheList();
            }

            public void undo() {
                super.undo();
                EMFObservableList.this.refreshCacheList();
            }

            public void redo() {
                super.redo();
                EMFObservableList.this.refreshCacheList();
            }

            protected boolean prepare() {
                if (this.commandList.isEmpty()) {
                    return false;
                }
                return ((Command)this.commandList.get(0)).canExecute();
            }
        };
        for (Command cmd : this.commands) {
            compoundCommand.append(cmd);
        }
        this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        this.refreshCacheList();
        this.commands.clear();
        this.isCommitting = false;
    }

    protected void refreshCacheList() {
        if (this.isDisposed()) {
            return;
        }
        this.wrappedList.clear();
        this.wrappedList.addAll(this.concreteList);
        this.fireListChange(null);
    }

    public void add(int index, Object value) {
        Command command = this.getAddCommand(index, value);
        this.commands.add(command);
        this.wrappedList.add(index, value);
        this.fireListChange(null);
    }

    public void clear() {
        Command command = this.getClearCommand();
        this.commands.add(command);
        this.wrappedList.clear();
        this.fireListChange(null);
    }

    public boolean add(Object o) {
        Command command = this.getAddCommand(o);
        this.commands.add(command);
        boolean result = this.wrappedList.add(o);
        this.fireListChange(null);
        return result;
    }

    public boolean remove(Object o) {
        Command command = this.getRemoveCommand(o);
        this.commands.add(command);
        boolean result = this.wrappedList.remove(o);
        this.fireListChange(null);
        return result;
    }

    public boolean addAll(Collection c) {
        Command command = this.getAddAllCommand(c);
        this.commands.add(command);
        boolean result = this.wrappedList.addAll(c);
        this.fireListChange(null);
        return result;
    }

    public boolean addAll(int index, Collection c) {
        Command command = this.getAddAllCommand(index, c);
        this.commands.add(command);
        boolean result = this.wrappedList.addAll(index, c);
        this.fireListChange(null);
        return result;
    }

    public boolean removeAll(Collection c) {
        Command command = this.getRemoveCommand(c);
        this.commands.add(command);
        boolean result = this.wrappedList.removeAll(c);
        this.fireListChange(null);
        return result;
    }

    public boolean retainAll(Collection c) {
        Command command = this.getRetainAllCommand(c);
        this.commands.add(command);
        boolean result = this.wrappedList.retainAll(c);
        this.fireListChange(null);
        return result;
    }

    public Object set(int index, Object element) {
        Command command = this.getSetCommand(index, element);
        this.commands.add(command);
        Object result = this.wrappedList.set(index, element);
        this.fireListChange(null);
        return result;
    }

    public Object move(int oldIndex, int newIndex) {
        this.commands.addAll(this.getMoveCommands(oldIndex, newIndex));
        Object value = this.get(oldIndex);
        this.wrappedList.remove(oldIndex);
        this.wrappedList.add(newIndex, value);
        this.fireListChange(null);
        return value;
    }

    public Object remove(int index) {
        Object value = this.get(index);
        if (value != null) {
            Command command = this.getRemoveCommand(index);
            this.commands.add(command);
        }
        Object result = this.wrappedList.remove(index);
        this.fireListChange(null);
        return result;
    }

    public Command getAddCommand(int index, Object value) {
        return AddCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, (Object)value, (int)index);
    }

    public Command getAddCommand(Object value) {
        return AddCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, (Object)value);
    }

    public Command getAddAllCommand(Collection<?> values) {
        return AddCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, values);
    }

    public Command getAddAllCommand(int index, Collection<?> values) {
        return AddCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, values, (int)index);
    }

    public Command getClearCommand() {
        return this.getRemoveAllCommand(new LinkedList(this.wrappedList));
    }

    public Command getRemoveCommand(int index) {
        Object value = this.get(index);
        return this.getRemoveCommand(value);
    }

    public Command getRemoveCommand(Object value) {
        Command cmd = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, (Object)value);
        if (value instanceof EObject && this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
            this.addDestroyCommand(cmd, (EObject)value);
        }
        return cmd;
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        CompoundCommand cc = new CompoundCommand("Edit list");
        if (this.feature instanceof EReference && ((EReference)this.feature).isContainment() && values != null) {
            for (Object o : values) {
                if (!(o instanceof EObject)) continue;
                this.addDestroyCommand((Command)cc, (EObject)o);
            }
        }
        cc.append(RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, values));
        return cc;
    }

    public List<Command> getMoveCommands(int oldIndex, int newIndex) {
        Object value = this.get(oldIndex);
        LinkedList<Command> commands = new LinkedList<Command>();
        commands.add(this.getRemoveCommand(value));
        commands.add(this.getAddCommand(newIndex, value));
        return commands;
    }

    public Command getRetainAllCommand(Collection<?> values) {
        LinkedList objectsToRemove = new LinkedList();
        for (Object object : values) {
            if (this.contains(object)) continue;
            objectsToRemove.add(object);
        }
        if (!objectsToRemove.isEmpty()) {
            return this.getRemoveAllCommand(objectsToRemove);
        }
        return null;
    }

    public Command getSetCommand(int index, Object value) {
        Object oldValue = this.get(index);
        Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.source, (Object)this.feature, (Object)value, (int)index);
        if (oldValue instanceof EObject && this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
            this.addDestroyCommand(command, (EObject)oldValue);
        }
        return command;
    }

    protected void addDestroyCommand(Command cmd, EObject objToDestroy) {
        Command destroyCmd = DeleteCommand.create((EditingDomain)this.editingDomain, (Object)objToDestroy);
        if (cmd instanceof CompoundCommand) {
            ((CompoundCommand)cmd).append(destroyCmd);
        } else {
            cmd.chain(destroyCmd);
        }
    }
}

