/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.advice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyObjectEditAdvice
extends AbstractEditHelperAdvice {
    protected boolean isContainerUneditable(IEditCommandRequest request, EObject object) {
        Resource resource;
        boolean result = false;
        EObject container = object.eContainer();
        result = container == null ? (resource = object.eResource()) != null && this.isUneditable(request, resource) : this.isUneditable(request, container);
        return result;
    }

    protected boolean isUneditable(IEditCommandRequest request, EObject object) {
        boolean result = false;
        TransactionalEditingDomain domain = request.getEditingDomain();
        if (EMFHelper.isReadOnly(object, (EditingDomain)domain)) {
            result = !EMFHelper.canMakeWritable(object, (EditingDomain)domain);
        }
        return result;
    }

    protected boolean isUneditable(IEditCommandRequest request, Resource resource) {
        boolean result = false;
        TransactionalEditingDomain domain = request.getEditingDomain();
        if (EMFHelper.isReadOnly(resource, (EditingDomain)domain)) {
            result = !EMFHelper.canMakeWritable(resource, (EditingDomain)domain);
        }
        return result;
    }

    protected ICommand getRefusal() {
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        EObject container = request.getContainer();
        if (container != null && this.isUneditable((IEditCommandRequest)request, container)) {
            return this.getRefusal();
        }
        return super.getBeforeCreateCommand(request);
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        EObject container = request.getContainer();
        if (container != null && this.isUneditable((IEditCommandRequest)request, container)) {
            return this.getRefusal();
        }
        if (this.isUneditable((IEditCommandRequest)request, request.getSource())) {
            return this.getRefusal();
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest request) {
        EObject container = request.getContainer();
        if (container != null && this.isUneditable((IEditCommandRequest)request, container)) {
            return this.getRefusal();
        }
        return super.getBeforeDestroyElementCommand(request);
    }

    protected ICommand getBeforeDestroyReferenceCommand(DestroyReferenceRequest request) {
        EObject referenced;
        EObject container = request.getContainer();
        if (container != null && this.isUneditable((IEditCommandRequest)request, container)) {
            return this.getRefusal();
        }
        EReference ref = request.getContainingFeature();
        if (ref.getEOpposite() != null && (referenced = request.getReferencedObject()) != null && this.isUneditable((IEditCommandRequest)request, referenced)) {
            return this.getRefusal();
        }
        return super.getBeforeDestroyReferenceCommand(request);
    }

    protected ICommand getBeforeDuplicateCommand(DuplicateElementsRequest request) {
        List elements = request.getElementsToBeDuplicated();
        for (EObject next : Iterables.filter((Iterable)elements, EObject.class)) {
            EObject container = next.eContainer();
            if (container == null || !this.isUneditable((IEditCommandRequest)request, container)) continue;
            return this.getRefusal();
        }
        return super.getBeforeDuplicateCommand(request);
    }

    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        for (EObject next : Iterables.filter(request.getElementsToMove().keySet(), EObject.class)) {
            if (!this.isContainerUneditable((IEditCommandRequest)request, next)) continue;
            return this.getRefusal();
        }
        if (this.isUneditable((IEditCommandRequest)request, request.getTargetContainer())) {
            return this.getRefusal();
        }
        return super.getBeforeMoveCommand(request);
    }

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        EObject relationship = request.getRelationship();
        if (relationship != null && this.isUneditable((IEditCommandRequest)request, relationship)) {
            return this.getRefusal();
        }
        if (request.getDirection() == 1) {
            if (this.isUneditable((IEditCommandRequest)request, request.getOldRelationshipEnd())) {
                return this.getRefusal();
            }
            if (this.isUneditable((IEditCommandRequest)request, request.getNewRelationshipEnd())) {
                return this.getRefusal();
            }
        }
        return super.getBeforeReorientRelationshipCommand(request);
    }

    protected ICommand getBeforeReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest request) {
        EObject owner = request.getReferenceOwner();
        if (owner != null && this.isUneditable((IEditCommandRequest)request, owner)) {
            return this.getRefusal();
        }
        if (request.getDirection() == 1) {
            if (this.isUneditable((IEditCommandRequest)request, request.getOldRelationshipEnd())) {
                return this.getRefusal();
            }
            if (this.isUneditable((IEditCommandRequest)request, request.getNewRelationshipEnd())) {
                return this.getRefusal();
            }
        }
        return super.getBeforeReorientReferenceRelationshipCommand(request);
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        if (this.isUneditable((IEditCommandRequest)request, request.getElementToEdit())) {
            return this.getRefusal();
        }
        if (request.getFeature() instanceof EReference) {
            EReference ref = (EReference)request.getFeature();
            if (ref.getEOpposite() != null) {
                Collection<EObject> affectedOpposites = this.getAffectedOpposites(request.getElementToEdit(), ref, request.getValue());
                if (!affectedOpposites.isEmpty()) {
                    for (EObject next : affectedOpposites) {
                        if (!this.isUneditable((IEditCommandRequest)request, next)) continue;
                        return this.getRefusal();
                    }
                }
            } else if (ref.isContainment()) {
                EObject owner = request.getElementToEdit();
                Object value = request.getValue();
                if (value instanceof Collection) {
                    for (EObject next : Iterables.filter((Iterable)((Collection)value), EObject.class)) {
                        if (next.eContainer() == owner || !this.isContainerUneditable((IEditCommandRequest)request, next)) continue;
                        return this.getRefusal();
                    }
                } else if (request.getValue() instanceof EObject && this.isContainerUneditable((IEditCommandRequest)request, (EObject)value)) {
                    return this.getRefusal();
                }
            }
        }
        return null;
    }

    protected Collection<EObject> getAffectedOpposites(EObject source, EReference refWithOpposite, Object newValue) {
        Object result;
        if (refWithOpposite.isMany()) {
            if (newValue == null || newValue instanceof Collection && ((Collection)newValue).isEmpty()) {
                result = this.getReferencedObjects(source, refWithOpposite);
            } else {
                HashSet current = Sets.newHashSet(this.getReferencedObjects(source, refWithOpposite));
                ImmutableSet future = newValue instanceof Collection ? ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)((Collection)newValue), EObject.class)) : Collections.singleton((EObject)newValue);
                result = ImmutableList.copyOf((Collection)Sets.symmetricDifference((Set)current, (Set)future));
            }
        } else {
            Object current = source.eGet((EStructuralFeature)refWithOpposite);
            result = current != newValue ? (current == null ? Collections.singletonList((EObject)newValue) : (newValue == null ? Collections.singleton((EObject)current) : ImmutableList.of((Object)((EObject)current), (Object)((EObject)newValue)))) : Collections.emptyList();
        }
        return result;
    }

    private Collection<EObject> getReferencedObjects(EObject source, EReference reference) {
        Object current = source.eGet((EStructuralFeature)reference);
        Object result = current instanceof Collection ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)((Collection)current), EObject.class)) : (current != null ? Collections.singletonList((EObject)current) : Collections.emptyList());
        return result;
    }
}

