/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.CustomizationComparator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.emf";
    private static Activator plugin;
    public static LogHelper log;
    private ICustomizationManager fCustomizationManager;
    private ResourceSet facetRecsourceSet = new ResourceSetImpl();
    public static final String CUSTOMIZATION_MANAGER_SECTION = "org.eclipse.papyrus.infra.emf.customizationManager";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ICustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.facetRecsourceSet);
            this.init(this.fCustomizationManager);
        }
        return this.fCustomizationManager;
    }

    public void saveCustomizationManagerState() {
        IDialogSettings dialogSettings = this.getBrowserCustomizationDialogSettings();
        List appliedCustomizations = this.getCustomizationManager().getManagedCustomizations();
        List registeredCustomizations = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.getCustomizationManager().getResourceSet()).getRegisteredCustomizations();
        for (Customization customization : registeredCustomizations) {
            boolean isApplied = appliedCustomizations.contains(customization);
            String settingKey = this.getSettingKey(customization);
            dialogSettings.put(settingKey, isApplied);
        }
    }

    private String getSettingKey(Customization customization) {
        return customization.eResource().getURI().toString();
    }

    protected IDialogSettings getBrowserCustomizationDialogSettings() {
        String sectionId = CUSTOMIZATION_MANAGER_SECTION;
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionId);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionId);
        }
        return settings;
    }

    private void init(ICustomizationManager customizationManager) {
        IDialogSettings settings = this.getBrowserCustomizationDialogSettings();
        try {
            ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(customizationManager.getResourceSet());
            List registryAllCustomizations = customCatalog.getRegisteredCustomizations();
            ArrayList<Customization> orderedCustomizationList = new ArrayList<Customization>();
            for (Customization customization : registryAllCustomizations) {
                String settingKey = this.getSettingKey(customization);
                boolean isActive = false;
                isActive = settings.get(settingKey) == null ? customization.isMustBeLoadedByDefault() : settings.getBoolean(settingKey);
                if (!isActive) continue;
                orderedCustomizationList.add(customization);
            }
            Collections.sort(orderedCustomizationList, new CustomizationComparator());
            customizationManager.getManagedCustomizations().addAll(orderedCustomizationList);
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e));
        }
    }

    public void restoreDefaultCustomizationManager() {
        ICustomizationManager manager = this.getCustomizationManager();
        DialogSettings settings = (DialogSettings)this.getDialogSettings();
        settings.removeSection(CUSTOMIZATION_MANAGER_SECTION);
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }
}

