/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.parsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityLabelParser
implements ISemanticParser {
    protected static final String MULTIPLICITY_FORMAT = "%s..%s";

    public String getPrintString(IAdaptable element, int flags) {
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof MultiplicityElement) {
            MultiplicityElement multiplicity = (MultiplicityElement)eObject;
            String lower = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)multiplicity.getLowerValue());
            String upper = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)multiplicity.getUpperValue());
            result = multiplicity.getLower() != multiplicity.getUpper() ? String.format(MULTIPLICITY_FORMAT, lower, upper) : lower;
        }
        return result;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature);
        }
        return false;
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof MultiplicityElement) {
            MultiplicityElement semElement = (MultiplicityElement)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }
}

