/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;

public class CallOperationActionParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String NAME_CLASS_OPERATION_FORMAT = "%s\n(%s::%s)";
    private static final String NAME_CLASS_FORMAT = "%s\n(%s::)";
    private static final String NAME_FORMAT = "%s";

    public CallOperationActionParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public CallOperationActionParser(EAttribute[] features) {
        super(features);
    }

    public CallOperationActionParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof CallOperationAction) {
            CallOperationAction action = (CallOperationAction)obj;
            String name = action.getName();
            String operation = "";
            String className = "";
            if (name == null) {
                name = "";
            }
            if (action.getOperation() != null) {
                operation = action.getOperation().getName();
                if (operation == null) {
                    operation = "";
                }
                if (action.getOperation().getClass_() != null && (className = action.getOperation().getClass_().getName()) == null) {
                    className = "";
                }
            }
            return this.getPrintString(name, operation, className);
        }
        return " ";
    }

    private String getPrintString(String name, String operation, String className) {
        if ("".equals(name) || operation.equals(name)) {
            if ("".equals(className)) {
                return String.format(NAME_FORMAT, operation);
            }
            return String.format(NAME_CLASS_FORMAT, operation, className);
        }
        if ("".equals(operation) && "".equals(className)) {
            return String.format(NAME_FORMAT, name);
        }
        return String.format(NAME_CLASS_OPERATION_FORMAT, name, className, operation);
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof CallOperationAction) {
            CallOperationAction action = (CallOperationAction)element;
            semanticElementsBeingParsed.add(action);
            Operation operation = action.getOperation();
            if (operation != null) {
                semanticElementsBeingParsed.add(operation);
                if (operation.getClass_() != null) {
                    semanticElementsBeingParsed.add(operation.getClass_());
                }
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        boolean isPrintedElement;
        boolean isName = UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature);
        boolean bl = isPrintedElement = UMLPackage.eINSTANCE.getCallOperationAction_Operation().equals(feature) || UMLPackage.eINSTANCE.getOperation_Class().equals(feature);
        return isName || isPrintedElement;
    }
}

