/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityContentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityParametersCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityPostConditionsCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityPreConditionsCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityIsSingleExecutionEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityNameEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityParameterNodeEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.RemoveOrphanViewPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.ResizeActivityEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.figures.ActivityFigure;
import org.eclipse.papyrus.uml.diagram.activity.locator.ParameterNodeLocator;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ActivityEditPart
extends NamedElementEditPart {
    public static final int VISUAL_ID = 2001;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new PapyrusCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("RemoveOrphanView", (EditPolicy)new RemoveOrphanViewPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizeActivityEditPolicy());
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 3059: {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ActivityFigure();
        return this.primaryShape;
    }

    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            ((ActivityNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof ActivityIsSingleExecutionEditPart) {
            ((ActivityIsSingleExecutionEditPart)childEditPart).setLabel(this.getPrimaryShape().getHeaderSingleExecution());
            return true;
        }
        if (childEditPart instanceof ActivityActivityParametersCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getParameterFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((ActivityActivityParametersCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityActivityPreConditionsCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getPreconditionFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((ActivityActivityPreConditionsCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityActivityPostConditionsCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getPostconditionFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((ActivityActivityPostConditionsCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityActivityContentCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getContentFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((ActivityActivityContentCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityParameterNodeEditPart) {
            ParameterNodeLocator locator = new ParameterNodeLocator(this.getMainFigure(), 8);
            this.getBorderedFigure().getBorderItemContainer().add(((ActivityParameterNodeEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            return true;
        }
        if (childEditPart instanceof ActivityIsSingleExecutionEditPart) {
            return true;
        }
        if (childEditPart instanceof ActivityActivityParametersCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getParameterFigure();
            pane.remove(((ActivityActivityParametersCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityActivityPreConditionsCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getPreconditionFigure();
            pane.remove(((ActivityActivityPreConditionsCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityActivityPostConditionsCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getPostconditionFigure();
            pane.remove(((ActivityActivityPostConditionsCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityActivityContentCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getContentFigure();
            pane.remove(((ActivityActivityContentCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ActivityParameterNodeEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((ActivityParameterNodeEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof ActivityActivityParametersCompartmentEditPart) {
            return this.getPrimaryShape().getParameterFigure();
        }
        if (editPart instanceof ActivityActivityPreConditionsCompartmentEditPart) {
            return this.getPrimaryShape().getPreconditionFigure();
        }
        if (editPart instanceof ActivityActivityPostConditionsCompartmentEditPart) {
            return this.getPrimaryShape().getPostconditionFigure();
        }
        if (editPart instanceof ActivityActivityContentCompartmentEditPart) {
            return this.getPrimaryShape().getContentFigure();
        }
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "Activity";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5001));
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(2);
        types.add(UMLElementTypes.CommentAnnotatedElement_4006);
        types.add(UMLElementTypes.ConstraintConstrainedElement_4007);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.CommentAnnotatedElement_4006) {
            types.add(UMLElementTypes.Comment_3080);
        } else if (relationshipType == UMLElementTypes.ConstraintConstrainedElement_4007) {
            types.add(UMLElementTypes.DurationConstraint_3034);
            types.add(UMLElementTypes.DurationConstraint_3035);
            types.add(UMLElementTypes.TimeConstraint_3036);
            types.add(UMLElementTypes.TimeConstraint_3037);
            types.add(UMLElementTypes.IntervalConstraint_3032);
            types.add(UMLElementTypes.IntervalConstraint_3033);
            types.add(UMLElementTypes.Constraint_3011);
            types.add(UMLElementTypes.Constraint_3012);
            types.add(UMLElementTypes.Constraint_3112);
        }
        return types;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateViewAndElementRequest) {
            CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter();
            IElementType type = (IElementType)adapter.getAdapter(IElementType.class);
            if (type == UMLElementTypes.Parameter_3001) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7001));
            }
            if (type == UMLElementTypes.Constraint_3002) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7002));
            }
            if (type == UMLElementTypes.Constraint_3003) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7003));
            }
        }
        return super.getTargetEditPart(request);
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"Activity", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"Activity", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"Activity", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferencesConstantsHelper.getElementConstant((String)"Activity", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }
}

