/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.papyrus.infra.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.commands.AsyncValidateSubtreeCommand;
import org.eclipse.papyrus.uml.service.validation.UMLDiagnostician;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.Messages;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.UMLConstraintEditorActivator;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.resource.XtextResource;

public class EssentialOCLEditorConfiguration
extends DefaultXtextDirectEditorConfiguration {
    private static final String OCL = "OCL";
    @Inject
    protected XtextResource fakeResource;

    public int getStyle() {
        return 66;
    }

    public Object preEditAction(Object editedObject) {
        String stringValue;
        Constraint constraint;
        if (editedObject instanceof Constraint && !((constraint = (Constraint)editedObject).getSpecification() instanceof OpaqueExpression) && (stringValue = constraint.getSpecification().stringValue()) != null && stringValue.length() > 0) {
            MessageDialog.openWarning((Shell)new Shell(), (String)Messages.EssentialOCLEditorConfiguration_ExistingSpecification, (String)Messages.EssentialOCLEditorConfiguration_AlreadyContainsNonEmpty);
        }
        return super.preEditAction(editedObject);
    }

    public String getTextToEdit(Object editedObject) {
        String value = "";
        ValueSpecification specification = null;
        if (this.objectToEdit instanceof Constraint) {
            specification = ((Constraint)this.objectToEdit).getSpecification();
        } else if (this.objectToEdit instanceof ValueSpecification) {
            specification = (ValueSpecification)this.objectToEdit;
        }
        if (specification != null) {
            if (specification instanceof LiteralString) {
                if (((LiteralString)specification).getValue() != null) {
                    value = String.valueOf(value) + ((LiteralString)specification).getValue();
                }
            } else if (specification instanceof OpaqueExpression) {
                int indexOfOCLBody = -1;
                OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals(OCL)) {
                        if (i < opaqueExpression.getBodies().size()) {
                            value = String.valueOf(value) + (String)opaqueExpression.getBodies().get(i);
                        }
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
        }
        return value;
    }

    public ContextElementAdapter.IContextElementProvider getContextProvider() {
        return new ContextElementAdapter.IContextElementProviderWithInit(){

            public EObject getContextObject() {
                Element owner;
                if (EssentialOCLEditorConfiguration.this.objectToEdit instanceof Constraint) {
                    return ((Constraint)EssentialOCLEditorConfiguration.this.objectToEdit).getContext();
                }
                if (EssentialOCLEditorConfiguration.this.objectToEdit instanceof OpaqueExpression && (owner = ((OpaqueExpression)EssentialOCLEditorConfiguration.this.objectToEdit).getOwner()) instanceof Constraint) {
                    return ((Constraint)owner).getContext();
                }
                return null;
            }

            public void initResource(XtextResource resource) {
                try {
                    if (resource instanceof BaseResource) {
                        PivotUtil.setParserContext((BaseResource)((BaseResource)resource), (EObject)this.getContextObject(), (Object[])new Object[0]);
                    }
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        };
    }

    public Injector getInjector() {
        return UMLConstraintEditorActivator.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
    }

    public IParser createParser(final EObject semanticObject) {
        if (this.objectToEdit == null) {
            this.objectToEdit = semanticObject;
        }
        final IParser defaultParser = super.createParser(semanticObject);
        return new ISemanticParser(){

            public String getEditString(IAdaptable element, int flags) {
                return defaultParser.getEditString(element, flags);
            }

            public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
                boolean doValidation;
                CompositeCommand result = new CompositeCommand("validation");
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)semanticObject);
                boolean bl = doValidation = editingDomain != null;
                if (editingDomain == null) {
                    ResourceSet rs = NestedEditingDialogContext.getInstance().getResourceSet();
                    editingDomain = TransactionUtil.getEditingDomain((ResourceSet)rs);
                }
                if (semanticObject instanceof Constraint) {
                    result.add((IUndoableOperation)new UpdateConstraintCommand(editingDomain, (Constraint)semanticObject, newString));
                } else if (semanticObject instanceof OpaqueExpression) {
                    result.add((IUndoableOperation)new UpdateOpaqueExpressionCommand(editingDomain, (OpaqueExpression)semanticObject, newString));
                }
                if (doValidation) {
                    AsyncValidateSubtreeCommand validationCommand = new AsyncValidateSubtreeCommand(semanticObject, (IPapyrusDiagnostician)new UMLDiagnostician());
                    validationCommand.disableUIFeedback();
                    result.add((IUndoableOperation)validationCommand);
                }
                return result;
            }

            public String getPrintString(IAdaptable element, int flags) {
                return defaultParser.getPrintString(element, flags);
            }

            public boolean isAffectingEvent(Object event, int flags) {
                return false;
            }

            public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
                return null;
            }

            public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
                return null;
            }

            public List getSemanticElementsBeingParsed(EObject element) {
                BasicEList list = new BasicEList();
                if (element instanceof Constraint) {
                    list.add(((Constraint)element).getSpecification());
                }
                return list;
            }

            public boolean areSemanticElementsAffected(EObject listener, Object notification) {
                return true;
            }
        };
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        return UnexecutableCommand.INSTANCE;
    }

    protected class UpdateConstraintCommand
    extends AbstractTransactionalCommand {
        protected final Constraint constraint;
        protected final String newTextualRepresentation;

        public UpdateConstraintCommand(TransactionalEditingDomain editingDomain, Constraint constraint, String newTextualRepresentation) {
            super(editingDomain, "Constraint Update", UpdateConstraintCommand.getWorkspaceFiles((EObject)constraint));
            this.constraint = constraint;
            this.newTextualRepresentation = newTextualRepresentation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            OpaqueExpression opaqueExpression = null;
            int indexOfOCLBody = -1;
            if (this.constraint.getSpecification() == null || !(this.constraint.getSpecification() instanceof OpaqueExpression)) {
                opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            } else {
                opaqueExpression = (OpaqueExpression)this.constraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals(EssentialOCLEditorConfiguration.OCL)) {
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
            if (indexOfOCLBody == -1) {
                opaqueExpression.getLanguages().add((Object)EssentialOCLEditorConfiguration.OCL);
                opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            } else {
                opaqueExpression.getBodies().set(indexOfOCLBody, (Object)this.newTextualRepresentation);
            }
            this.constraint.setSpecification((ValueSpecification)opaqueExpression);
            return CommandResult.newOKCommandResult((Object)this.constraint);
        }
    }

    protected class UpdateOpaqueExpressionCommand
    extends AbstractTransactionalCommand {
        protected final OpaqueExpression opaqueExpression;
        protected final String newTextualRepresentation;

        public UpdateOpaqueExpressionCommand(TransactionalEditingDomain editingDomain, OpaqueExpression expression, String newTextualRepresentation) {
            super(editingDomain, "Opaque expression update", UpdateOpaqueExpressionCommand.getWorkspaceFiles((EObject)expression));
            this.opaqueExpression = expression;
            this.newTextualRepresentation = newTextualRepresentation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            int indexOfOCLBody = -1;
            int i = 0;
            while (i < this.opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                if (((String)this.opaqueExpression.getLanguages().get(i)).equals(EssentialOCLEditorConfiguration.OCL)) {
                    indexOfOCLBody = i;
                }
                ++i;
            }
            if (indexOfOCLBody == -1) {
                this.opaqueExpression.getLanguages().add((Object)EssentialOCLEditorConfiguration.OCL);
                this.opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            } else if (indexOfOCLBody < this.opaqueExpression.getBodies().size()) {
                this.opaqueExpression.getBodies().set(indexOfOCLBody, (Object)this.newTextualRepresentation);
            } else {
                this.opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            }
            return CommandResult.newOKCommandResult((Object)this.opaqueExpression);
        }
    }
}

