/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.efs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.efs.AbstractFileStore;
import org.eclipse.emf.cdo.internal.efs.CDOFileRoot;
import org.eclipse.emf.cdo.internal.efs.CDOFileSystem;
import org.eclipse.emf.cdo.internal.efs.bundle.OM;
import org.eclipse.emf.cdo.view.CDOView;
import org.xml.sax.InputSource;

public final class CDOFileStore
extends AbstractFileStore {
    private static final Path PROJECT_DESCRIPTION_PATH = new Path(".project");
    private CDOFileRoot root;
    private IPath path;

    public CDOFileStore(CDOFileRoot root, IPath path) {
        this.root = root;
        this.path = path;
    }

    public CDOFileSystem getFileSystem() {
        return this.root.getFileSystem();
    }

    public CDOFileRoot getRoot() {
        return this.root;
    }

    public CDOView getView(IProgressMonitor monitor) {
        return this.root.getView(monitor);
    }

    protected CDOResourceNode doGetResourceNode(IProgressMonitor monitor) {
        return this.getView(monitor).getResourceNode(this.path.toPortableString());
    }

    public IPath getPath() {
        return this.path;
    }

    public IFileStore getParent() {
        if (this.path.segmentCount() == 1) {
            return this.root;
        }
        return new CDOFileStore(this.root, this.path.removeLastSegments(1));
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo info = new FileInfo(this.getName());
        info.setLastModified(0L);
        info.setLength(0L);
        info.setAttribute(2, false);
        if (this.isProjectDescription()) {
            info.setExists(this.getProjectName() != null);
            info.setDirectory(false);
        } else {
            try {
                CDOResourceNode resourceNode = this.getResourceNode(monitor);
                info.setExists(true);
                info.setDirectory(resourceNode instanceof CDOResourceFolder);
            }
            catch (Exception ex) {
                info.setExists(false);
            }
        }
        return info;
    }

    @Deprecated
    public IFileStore getChild(IPath path) {
        return new CDOFileStore(this.root, this.path.append(path));
    }

    public IFileStore getChild(String name) {
        return new CDOFileStore(this.root, this.path.append(name));
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        CDOResourceNode resourceNode = this.getResourceNode(monitor);
        if (resourceNode instanceof CDOResourceFolder) {
            CDOResourceFolder resourceFolder = (CDOResourceFolder)resourceNode;
            for (CDOResourceNode node : resourceFolder.getNodes()) {
                result.add(node.getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.toByteArray());
                    ProjectDescription description = new ProjectDescriptionReader().read(new InputSource(bais));
                    OM.associateProjectName(CDOFileStore.this.root.toURI(), description.getName());
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        };
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.isProjectDescription()) {
                this.writeProjectDescription(baos, monitor);
            } else {
                this.writeResource(baos, monitor);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.cdo.efs", ex.getLocalizedMessage(), (Throwable)ex));
        }
        finally {
            monitor.done();
        }
    }

    private String getProjectName() {
        return OM.getProjectName(this.root.toURI());
    }

    private boolean isProjectDescription() {
        return this.path.equals((Object)PROJECT_DESCRIPTION_PATH);
    }

    private void writeProjectDescription(ByteArrayOutputStream baos, IProgressMonitor monitor) {
        PrintStream out = new PrintStream(baos);
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<projectDescription>");
        out.println("  <name>" + OM.getProjectName(this.root.toURI()) + "</name>");
        out.println("  <comment></comment>");
        out.println("  <projects>");
        out.println("  </projects>");
        out.println("  <buildSpec>");
        out.println("  </buildSpec>");
        out.println("  <natures>");
        out.println("  </natures>");
        out.println("</projectDescription>");
        out.flush();
    }

    private void writeResource(ByteArrayOutputStream baos, IProgressMonitor monitor) throws IOException {
        CDOResource resource = (CDOResource)this.getResourceNode(monitor);
        resource.save((OutputStream)baos, null);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == CDOFileStore.class) {
            CDOFileStore that = (CDOFileStore)((Object)obj);
            return this.root == that.root && this.path.equals((Object)that.path);
        }
        return false;
    }

    protected int createHashCode() {
        return this.root.hashCode() ^ this.path.hashCode();
    }

    public void appendURI(StringBuilder builder) {
        this.root.appendURI(builder);
        builder.append("/");
        builder.append(this.path.toPortableString());
    }
}

