/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.efs;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.efs.AbstractFileStore;
import org.eclipse.emf.cdo.internal.efs.CDOFileStore;
import org.eclipse.emf.cdo.internal.efs.CDOFileSystem;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.ObjectUtil;

public final class CDOFileRoot
extends AbstractFileStore {
    private CDOFileSystem fileSystem;
    private String authority;
    private String repositoryName;
    private IPath branchPath;
    private long timeStamp;
    private transient CDOView view;

    public CDOFileRoot(CDOFileSystem fileSystem, String authority, String repositoryName, IPath branchPath, long timeStamp) {
        this.fileSystem = fileSystem;
        this.authority = authority;
        this.repositoryName = repositoryName;
        this.branchPath = branchPath;
        this.timeStamp = timeStamp;
    }

    public CDOFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public IPath getBranchPath() {
        return this.branchPath;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public IPath getPath() {
        return Path.EMPTY;
    }

    public CDOView getView(IProgressMonitor monitor) {
        if (this.view == null) {
            this.view = this.fileSystem.getView(this, monitor);
        }
        return this.view;
    }

    protected CDOResourceNode doGetResourceNode(IProgressMonitor monitor) {
        return this.getView(monitor).getRootResource();
    }

    public IFileStore getParent() {
        return null;
    }

    public String getName() {
        return "";
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo info = new FileInfo(this.getName());
        info.setLastModified(0L);
        info.setExists(true);
        info.setLength(0L);
        info.setDirectory(true);
        info.setAttribute(2, false);
        return info;
    }

    @Deprecated
    public IFileStore getChild(IPath path) {
        return new CDOFileStore(this, path);
    }

    public IFileStore getChild(String name) {
        return this.getChild((IPath)new Path(name));
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        for (EObject object : this.getView(monitor).getRootResource().getContents()) {
            if (!(object instanceof CDOResourceNode)) continue;
            CDOResourceNode node = (CDOResourceNode)object;
            result.add(node.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == CDOFileRoot.class) {
            CDOFileRoot that = (CDOFileRoot)((Object)obj);
            if (this.view != null && this.view == that.view) {
                return true;
            }
            return this.authority.equals(that.authority) && this.repositoryName.equals(that.repositoryName) && this.branchPath.equals((Object)that.branchPath) && this.timeStamp == that.timeStamp;
        }
        return false;
    }

    protected int createHashCode() {
        return this.authority.hashCode() ^ this.repositoryName.hashCode() ^ this.branchPath.hashCode() ^ ObjectUtil.hashCode((long)this.timeStamp);
    }

    public void appendURI(StringBuilder builder) {
        builder.append(this.fileSystem.getScheme());
        builder.append("://");
        builder.append(this.authority);
        builder.append("/");
        builder.append(this.repositoryName);
        builder.append("/");
        builder.append(this.branchPath.toPortableString());
        builder.append("/@");
        if (this.timeStamp != 0L) {
            builder.append(this.timeStamp);
        }
    }
}

