/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.efs;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.efs.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;

public abstract class AbstractFileStore
extends FileStore {
    private transient int hashCode;
    private transient CDOResourceNode resourceNode;

    public abstract IPath getPath();

    public abstract CDOView getView(IProgressMonitor var1);

    public final CDOTransaction openTransaction(IProgressMonitor monitor) {
        CDOSession session = this.getView(monitor).getSession();
        return session.openTransaction();
    }

    public final CDOResourceNode getResourceNode(IProgressMonitor monitor) {
        if (this.resourceNode == null) {
            this.resourceNode = this.doGetResourceNode(monitor);
        }
        return this.resourceNode;
    }

    protected abstract CDOResourceNode doGetResourceNode(IProgressMonitor var1);

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        CDOTransaction transaction = null;
        try {
            try {
                transaction = this.openTransaction(monitor);
                this.resourceNode = transaction.createResourceFolder(this.getPath().toPortableString());
                transaction.commit(monitor);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        return this;
    }

    public IFileStore getChild(String name) {
        return this.getChild((IPath)new Path(name));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.createHashCode();
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    protected abstract int createHashCode();

    public final URI toURI() {
        StringBuilder builder = new StringBuilder();
        this.appendURI(builder);
        return URI.create(builder.toString());
    }

    public abstract void appendURI(StringBuilder var1);
}

