/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.importsources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.importsources.IPackageImportSource;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPackageImportSource
implements IPackageImportSource {
    private ILabelProvider labelProvider;
    private IStaticContentProvider contentProvider;

    @Override
    public boolean canImportInto(Collection<?> selection) {
        return this.getPackage(selection) != null;
    }

    @Override
    public void initialize(Collection<?> selection) {
    }

    protected Package getPackage(Collection<?> selection) {
        Package result = null;
        for (Object next : selection) {
            EObject eObject;
            if (next instanceof Package) {
                result = (Package)next;
                break;
            }
            if (next == null || !((eObject = EMFHelper.getEObject(next)) instanceof Package)) continue;
            result = (Package)eObject;
        }
        return result;
    }

    @Override
    public final ILabelProvider getModelHierarchyLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = this.createModelHierarchyLabelProvider();
        }
        return this.labelProvider;
    }

    protected ILabelProvider createModelHierarchyLabelProvider() {
        return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    }

    @Override
    public IStaticContentProvider getModelHierarchyContentProvider(Map<String, String> extensionFilters) {
        if (this.contentProvider == null) {
            this.contentProvider = this.createModelHierarchyContentProvider(extensionFilters);
        }
        return this.contentProvider;
    }

    protected abstract IStaticContentProvider createModelHierarchyContentProvider(Map<String, String> var1);

    protected String getText(Object object) {
        return this.getModelHierarchyLabelProvider().getText(object);
    }

    @Override
    public List<Package> getPackages(ResourceSet resourceSet, Object model) throws CoreException {
        Resource resource = null;
        this.validateSelection(model);
        try {
            if (model instanceof Resource) {
                resource = (Resource)model;
                if (!resource.isLoaded()) {
                    resource.load(null);
                }
            } else if (model instanceof IFile) {
                IFile file = (IFile)model;
                resource = resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
            } else if (model instanceof URI) {
                resource = resourceSet.getResource((URI)model, true);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.tools", NLS.bind((String)"Failed to load packages from resource \"{0}\".", (Object)this.getText(model)), (Throwable)e));
        }
        if (resource == null) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.papyrus.uml.tools", NLS.bind((String)"Could not determine a model resource for \"{0}\".", (Object)this.getText(model))));
        }
        this.validateResource(resource, model);
        ArrayList<Package> result = new ArrayList<Package>(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE));
        if (result.isEmpty()) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.papyrus.uml.tools", NLS.bind((String)"No packages found in resource \"{0}\".", (Object)this.getText(model))));
        }
        return result;
    }

    protected void validateSelection(Object model) throws CoreException {
    }

    protected void validateResource(Resource resource, Object model) throws CoreException {
        if (resource.getContents().isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.tools", NLS.bind((String)"The model resource is empty: \"{0}\".", (Object)this.getText(model))));
        }
    }

    @Override
    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
    }
}

