/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools.preferences;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.releng.tools.preferences.ConfigurationBlock;
import org.eclipse.releng.tools.preferences.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class PomErrorLevelBlock
extends ConfigurationBlock {
    private static final Key KEY_POM_VERSION_ERROR_LEVEL = new Key("org.eclipse.releng.tools", "org.eclipse.releng.tools.invalidPomVersionErrorLevel");
    private static Key[] fgAllKeys = new Key[]{KEY_POM_VERSION_ERROR_LEVEL};
    private static final String[] SEVERITIES_LABELS = new String[]{"Error", "Warning", "Ignore"};
    private static final String[] SEVERITIES = new String[]{"Error", "Warning", "Ignore"};
    private SelectionListener selectionlistener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Combo) {
                Combo combo = (Combo)e.widget;
                ControlData data = (ControlData)combo.getData();
                data.key.setStoredValue(PomErrorLevelBlock.this.fLookupOrder[0], combo.getText(), PomErrorLevelBlock.this.fManager);
                PomErrorLevelBlock.this.fDirty = true;
            }
        }
    };
    private Combo fCombo = null;
    IScopeContext[] fLookupOrder = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    IWorkingCopyManager fManager = null;
    private Composite fMainComp = null;
    private IdentityHashMap fOldProjectSettings = null;
    boolean fDirty = false;

    public PomErrorLevelBlock(IWorkbenchPreferenceContainer container) {
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        this.fOldProjectSettings = null;
    }

    public Control createControl(Composite parent) {
        this.fMainComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fMainComp.setLayout((Layout)gl);
        this.fMainComp.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fMainComp.setFont(parent.getFont());
        this.fCombo = this.createComboControl(this.fMainComp, Messages.PomErrorLevelBlock_mismatched_pom_versions_pref, KEY_POM_VERSION_ERROR_LEVEL);
        Dialog.applyDialogFont((Control)this.fMainComp);
        return this.fMainComp;
    }

    public void performOK() {
        this.save();
    }

    public void performApply() {
        this.save();
    }

    private void save() {
        if (this.fDirty) {
            try {
                ArrayList changes = new ArrayList();
                this.collectChanges(this.fLookupOrder[0], changes);
                if (changes.size() > 0) {
                    this.fManager.applyChanges();
                }
                this.fDirty = false;
            }
            catch (BackingStoreException bse) {
                RelEngPlugin.log((IStatus)new Status(4, "org.eclipse.releng.tools", bse.getMessage(), (Throwable)bse));
            }
        }
    }

    public void performCancel() {
    }

    public void performDefaults() {
        String defval = null;
        int i = 0;
        while (i < fgAllKeys.length) {
            defval = fgAllKeys[i].getStoredValue(this.fLookupOrder, true, this.fManager);
            fgAllKeys[i].setStoredValue(this.fLookupOrder[0], defval, this.fManager);
            ++i;
        }
        this.updateCombos();
        this.fDirty = true;
    }

    private void updateCombos() {
        if (this.fCombo != null) {
            ControlData data = (ControlData)this.fCombo.getData();
            this.fCombo.select(data.getSelection(data.getKey().getStoredValue(this.fLookupOrder, false, this.fManager)));
        }
    }

    public void dispose() {
        this.fMainComp.getParent().dispose();
    }

    protected Combo createComboControl(Composite parent, String label, Key key) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(1, 2, true, false);
        lbl.setLayoutData((Object)gd);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        gd = new GridData(3, 2, false, false);
        combo.setLayoutData((Object)gd);
        ControlData data = new ControlData(key, SEVERITIES);
        combo.setData((Object)data);
        combo.setItems(SEVERITIES_LABELS);
        combo.addSelectionListener(this.selectionlistener);
        combo.select(data.getSelection(key.getStoredValue(this.fLookupOrder, false, this.fManager)));
        this.addHighlight(parent, lbl, combo);
        return combo;
    }

    private void collectChanges(IScopeContext context, List changes) {
        Key key = null;
        String origval = null;
        String newval = null;
        boolean complete = this.fOldProjectSettings == null;
        int i = 0;
        while (i < fgAllKeys.length) {
            key = fgAllKeys[i];
            origval = key.getStoredValue(context, null);
            newval = key.getStoredValue(context, this.fManager);
            if (newval == null) {
                if (origval != null) {
                    changes.add(key);
                } else if (complete) {
                    key.setStoredValue(context, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changes.add(key);
                }
            } else if (!newval.equals(origval)) {
                changes.add(key);
            }
            ++i;
        }
    }

    public static Key[] getAllKeys() {
        return fgAllKeys;
    }

    protected static class ControlData {
        Key key;
        private String[] values;

        public ControlData(Key key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public Key getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }

    protected static class Key {
        private String qualifier;
        private String key;

        public Key(String qualifier, String key) {
            this.qualifier = qualifier;
            this.key = key;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.qualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (node != null) {
                return node.get(this.key, null);
            }
            return null;
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (value != null) {
                node.put(this.key, value);
            } else {
                node.remove(this.key);
            }
        }

        public String toString() {
            return String.valueOf(this.qualifier) + '/' + this.key;
        }
    }
}

