/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.ui.operations.TagOperation;
import org.eclipse.ui.IWorkbenchPart;

public class TagAndReleaseOperation
extends TagOperation {
    private IResource[] selectedProjects;
    private CVSTag tag;
    private String comment;
    private MapProject mapProject;
    private boolean mapFileUpdated;

    public TagAndReleaseOperation(IWorkbenchPart part, MapProject mapProject, IResource[] resources, CVSTag t, String c) {
        super(part, TagAndReleaseOperation.asResourceMappers((IResource[])resources));
        this.selectedProjects = new IResource[resources.length];
        System.arraycopy(resources, 0, this.selectedProjects, 0, resources.length);
        this.tag = t;
        this.setTag(this.tag);
        this.comment = c;
        this.mapProject = mapProject;
    }

    public IStatus tag(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor progress) throws CVSException {
        progress.beginTask("Releasing project " + provider.getProject().getName(), 100);
        IStatus status = super.tag(provider, resources, recurse, (IProgressMonitor)new SubProgressMonitor(progress, 95));
        if (status.getSeverity() == 4) {
            return status;
        }
        progress.done();
        return status;
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask("Tagging with " + this.getTag().getName(), 100);
        super.execute((IProgressMonitor)new SubProgressMonitor(monitor, 95));
        monitor.subTask("Updating and committing map files");
        this.updateMapFile();
        if (!this.errorsOccurred()) {
            try {
                this.mapProject.commitMapProject(this.comment, monitor);
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
            this.mapFileUpdated = true;
        }
        monitor.done();
    }

    protected ISchedulingRule getSchedulingRule(CVSTeamProvider provider) {
        ISchedulingRule rule = super.getSchedulingRule(provider);
        return new MultiRule(new ISchedulingRule[]{rule, this.mapProject.getProject()});
    }

    private void updateTagsInMapFile(IProject project, String t) throws CVSException {
        try {
            this.mapProject.updateFile(project, t);
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
    }

    private void updateMapFile() throws CVSException {
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.selectedProjects[i] instanceof IProject) {
                this.updateTagsInMapFile((IProject)this.selectedProjects[i], this.tag.getName());
            }
            ++i;
        }
    }

    public boolean isMapFileUpdated() {
        return this.mapFileUpdated;
    }

    protected IStatus[] getErrors() {
        return super.getErrors();
    }
}

