/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.releng.tools.BatFile;
import org.eclipse.releng.tools.BlockComment;
import org.eclipse.releng.tools.CFile;
import org.eclipse.releng.tools.JavaFile;
import org.eclipse.releng.tools.JavaScriptFile;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.PropertiesFile;
import org.eclipse.releng.tools.ShellMakeFile;

public abstract class SourceFile {
    IFile file;
    List comments = new ArrayList();
    StringWriter contents = new StringWriter();
    private ITextFileBufferManager textFileBufferManager;
    private String lineDelimiter;

    public static SourceFile createFor(IFile file) {
        String extension = file.getFileExtension();
        if (extension != null) {
            if ((extension = extension.toLowerCase()).equals("java")) {
                return new JavaFile(file);
            }
            if (extension.equals("c") || extension.equals("h") || extension.equals("rc") || extension.equals("cc") || extension.equals("cpp")) {
                return new CFile(file);
            }
            if (extension.equals("properties")) {
                return new PropertiesFile(file);
            }
            if (extension.equals("sh") || extension.equals("csh") || extension.equals("mak") || extension.equals("pl") || extension.equals("tcl")) {
                return new ShellMakeFile(file);
            }
            if (extension.equals("bat")) {
                return new BatFile(file);
            }
            if (extension.equals("js")) {
                return new JavaScriptFile(file);
            }
            if (extension.equals("xml")) {
                // empty if block
            }
        }
        return null;
    }

    public SourceFile(IFile file) {
        this.file = file;
        this.initialize();
    }

    public boolean isCommentStart(String aLine) {
        return aLine.trim().startsWith(this.getCommentStart());
    }

    public boolean isCommentEnd(String aLine, String commentStartString) {
        return aLine.trim().endsWith(this.getCommentEnd());
    }

    public abstract String getCommentStart();

    public abstract String getCommentEnd();

    private void initialize() {
        this.textFileBufferManager = FileBuffers.createTextFileBufferManager();
        try {
            IDocument document;
            ITextFileBuffer fileBuffer = this.getFileBuffer();
            if (fileBuffer == null) {
                return;
            }
            try {
                document = fileBuffer.getDocument();
            }
            finally {
                try {
                    this.textFileBufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            BufferedReader aReader = new BufferedReader(new StringReader(document.get()));
            String aLine = aReader.readLine();
            String comment = "";
            BufferedWriter contentsWriter = new BufferedWriter(this.contents);
            int lineNumber = 0;
            int commentStart = 0;
            int commentEnd = 0;
            boolean inComment = false;
            String commentStartString = "";
            while (aLine != null) {
                contentsWriter.write(aLine);
                contentsWriter.newLine();
                if (!inComment && this.isCommentStart(aLine)) {
                    inComment = true;
                    commentStart = lineNumber;
                    commentStartString = aLine;
                }
                if (inComment) {
                    comment = String.valueOf(comment) + aLine + this.lineDelimiter;
                    if (this.isCommentEnd(aLine, commentStartString) && commentStart != lineNumber) {
                        inComment = false;
                        commentEnd = lineNumber;
                        String commentEndString = aLine.trim();
                        commentEndString = commentEndString.substring(commentEndString.length() - 2);
                        BlockComment aComment = new BlockComment(commentStart, commentEnd, comment.toString(), commentStartString, commentEndString);
                        this.comments.add(aComment);
                        comment = "";
                        commentStart = 0;
                        commentEnd = 0;
                        commentStartString = "";
                    }
                }
                aLine = aReader.readLine();
                ++lineNumber;
            }
            aReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BlockComment firstBlockComment() {
        if (this.comments.isEmpty()) {
            return null;
        }
        return (BlockComment)this.comments.get(0);
    }

    private ITextFileBuffer getFileBuffer() {
        try {
            this.textFileBufferManager.connect(this.file.getFullPath(), LocationKind.IFILE, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        ITextFileBuffer fileBuffer = this.textFileBufferManager.getTextFileBuffer(this.file.getFullPath(), LocationKind.IFILE);
        if (fileBuffer != null) {
            return fileBuffer;
        }
        System.err.println(NLS.bind((String)Messages.getString("SourceFile.0"), (Object)this.file.getFullPath()));
        return null;
    }

    /*
     * Loose catch block
     */
    public void insert(String string) {
        ITextFileBuffer fileBuffer = this.getFileBuffer();
        if (fileBuffer == null) {
            return;
        }
        try {
            try {
                IDocument document = fileBuffer.getDocument();
                this.doInsert(string, document);
                fileBuffer.commit(null, false);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                try {
                    this.textFileBufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                try {
                    this.textFileBufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException e3) {
                    e3.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    this.textFileBufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException e4) {
                    e4.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.textFileBufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doInsert(String comment, IDocument document) throws BadLocationException, CoreException, IOException {
        document.replace(0, 0, comment);
    }

    public BlockComment getFirstCopyrightComment() {
        Iterator anIterator = this.comments.iterator();
        while (anIterator.hasNext()) {
            BlockComment aComment = (BlockComment)anIterator.next();
            if (!aComment.isCopyright()) continue;
            return aComment;
        }
        return null;
    }

    public void replace(BlockComment aComment, String string) {
        try {
            ITextFileBuffer fileBuffer = this.getFileBuffer();
            if (fileBuffer == null) {
                return;
            }
            try {
                IDocument document = fileBuffer.getDocument();
                IRegion startLine = document.getLineInformation(aComment.start);
                IRegion endLine = document.getLineInformation(aComment.end + 1);
                document.replace(startLine.getOffset(), endLine.getOffset() - startLine.getOffset(), string);
                fileBuffer.commit(null, false);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                    return;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                FileBuffers.getTextFileBufferManager().disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public boolean hasMultipleCopyrights() {
        int count = 0;
        Iterator anIterator = this.comments.iterator();
        while (anIterator.hasNext()) {
            BlockComment aComment = (BlockComment)anIterator.next();
            if (aComment.isCopyright()) {
                ++count;
            }
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    public abstract int getFileType();

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }
}

