/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.releng.tools.BuildNotesPage;
import org.eclipse.releng.tools.CommitCommentPage;
import org.eclipse.releng.tools.MapFileComparePage;
import org.eclipse.releng.tools.MapProject;
import org.eclipse.releng.tools.MapProjectSelectionPage;
import org.eclipse.releng.tools.Messages;
import org.eclipse.releng.tools.ProjectComparePage;
import org.eclipse.releng.tools.ProjectSelectionPage;
import org.eclipse.releng.tools.ProjectValidationDialog;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.releng.tools.TagAndReleaseOperation;
import org.eclipse.releng.tools.TagPage;
import org.eclipse.releng.tools.ValidatePage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.team.internal.ui.dialogs.PromptingDialog;

public class ReleaseWizard
extends Wizard {
    private static final String BOUNDS_HEIGHT = "bounds.height";
    private static final String BOUNDS_WIDTH = "bounds.width";
    private static final String BOUNDS_Y = "bounds.y";
    private static final String BOUNDS_X = "bounds.x";
    private MapProjectSelectionPage mapSelectionPage;
    private ProjectSelectionPage projectSelectionPage;
    private TagPage tagPage;
    private ProjectComparePage projectComparePage;
    private MapFileComparePage mapComparePage;
    private CommitCommentPage commentPage;
    private BuildNotesPage buildNotesPage;
    private ValidatePage validatePage;
    private Dialog parentDialog;
    private IDialogSettings section;
    private MapProject mapProject;
    private IProject[] preSelectedProjects;
    private IProject[] selectedProjects;
    private IPreferenceStore preferenceStore;
    private boolean defaultBeingUsed;

    public ReleaseWizard() {
        this.setWindowTitle("Release");
        IDialogSettings settings = RelEngPlugin.getDefault().getDialogSettings();
        this.section = settings.getSection("ReleaseWizard");
        if (this.section == null) {
            this.section = settings.addNewSection("ReleaseWizard");
        }
        this.setDialogSettings(this.section);
        this.preferenceStore = RelEngPlugin.getDefault().getPreferenceStore();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.getDialogSettings().get(BOUNDS_X) != null) {
            int x = this.getDialogSettings().getInt(BOUNDS_X);
            int y = this.getDialogSettings().getInt(BOUNDS_Y);
            int width = this.getDialogSettings().getInt(BOUNDS_WIDTH);
            int height = this.getDialogSettings().getInt(BOUNDS_HEIGHT);
            this.getShell().setBounds(x, y, width, height);
        }
        this.getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                this.storeBounds(e);
            }

            public void controlResized(ControlEvent e) {
                this.storeBounds(e);
            }

            private void storeBounds(ControlEvent e) {
                Rectangle bounds = ReleaseWizard.this.getShell().getBounds();
                ReleaseWizard.this.getDialogSettings().put(ReleaseWizard.BOUNDS_X, bounds.x);
                ReleaseWizard.this.getDialogSettings().put(ReleaseWizard.BOUNDS_Y, bounds.y);
                ReleaseWizard.this.getDialogSettings().put(ReleaseWizard.BOUNDS_WIDTH, bounds.width);
                ReleaseWizard.this.getDialogSettings().put(ReleaseWizard.BOUNDS_HEIGHT, bounds.height);
            }
        });
    }

    public boolean execute(Shell shell) {
        this.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)this);
        this.setParentDialog((Dialog)dialog);
        return dialog.open() == 0;
    }

    public void addPages() {
        this.defaultBeingUsed = false;
        if (this.preferenceStore.getBoolean("useDefaultMapProject") && this.preferenceStore.getString("defaultMapProject").length() > 1) {
            String path = this.preferenceStore.getString("defaultMapProject");
            try {
                this.mapProject = new MapProject(ResourcesPlugin.getWorkspace().getRoot().getProject(path));
                this.defaultBeingUsed = true;
            }
            catch (CoreException coreException) {}
        }
        ImageDescriptor wizardPageImageDescriptor = TeamUIPlugin.getImageDescriptor((String)"wizban/share_wizban.png");
        if (!this.defaultBeingUsed) {
            this.addMapSelectionPage(wizardPageImageDescriptor);
        }
        this.projectSelectionPage = new ProjectSelectionPage("ProjectSelectionPage", Messages.getString("ReleaseWizard.6"), this.section, wizardPageImageDescriptor);
        this.projectSelectionPage.setDescription(Messages.getString("ReleaseWizard.7"));
        this.addPage((IWizardPage)this.projectSelectionPage);
        this.tagPage = new TagPage("TagPage", Messages.getString("ReleaseWizard.9"), this.section, wizardPageImageDescriptor);
        this.tagPage.setDescription(Messages.getString("ReleaseWizard.10"));
        this.addPage((IWizardPage)this.tagPage);
        this.projectComparePage = new ProjectComparePage("ProjectComparePage", Messages.getString("ReleaseWizard.12"), this.section, wizardPageImageDescriptor);
        this.projectComparePage.setDescription(Messages.getString("ReleaseWizard.13"));
        this.addPage((IWizardPage)this.projectComparePage);
        this.buildNotesPage = new BuildNotesPage("Build Notes Page", Messages.getString("ReleaseWizard.1"), this.section, wizardPageImageDescriptor);
        this.buildNotesPage.setDescription(Messages.getString("ReleaseWizard.0"));
        this.addPage((IWizardPage)this.buildNotesPage);
        this.mapComparePage = new MapFileComparePage("MapComparePage", Messages.getString("ReleaseWizard.15"), wizardPageImageDescriptor);
        this.mapComparePage.setDescription(Messages.getString("ReleaseWizard.16"));
        this.addPage((IWizardPage)this.mapComparePage);
        this.commentPage = new CommitCommentPage(this.parentDialog, "Commit", Messages.getString("ReleaseWizard.18"), wizardPageImageDescriptor, Messages.getString("ReleaseWizard.19"));
        this.addPage((IWizardPage)this.commentPage);
        this.validatePage = new ValidatePage(this.parentDialog, "ValidatePage", Messages.getString("ReleaseWizard.validatePageTitle"), wizardPageImageDescriptor);
        this.addPage((IWizardPage)this.validatePage);
        if (this.defaultBeingUsed) {
            this.broadcastMapProjectChange(this.mapProject);
        }
    }

    public void dispose() {
        if (this.mapProject != null) {
            this.mapProject.dispose();
            this.mapProject = null;
        }
        super.dispose();
    }

    private void addMapSelectionPage(ImageDescriptor wizardPageImageDescriptor) {
        this.mapSelectionPage = new MapProjectSelectionPage("MapProjectSelectionPage", Messages.getString("ReleaseWizard.4"), this.section, wizardPageImageDescriptor);
        this.mapSelectionPage.setDescription(Messages.getString("ReleaseWizard.3"));
        this.addPage((IWizardPage)this.mapSelectionPage);
    }

    public boolean buildNotesOperation() {
        if (this.buildNotesPage.isUpdateNotesButtonChecked() && this.projectComparePage.isBuildNotesButtonChecked()) {
            this.buildNotesPage.updateNotesFile();
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IFile iFile = ReleaseWizard.this.buildNotesPage.getIFile();
                        IProject iProject = iFile.getProject();
                        monitor.beginTask(Messages.getString("ReleaseWizard.20"), 100);
                        new CommitOperation(null, RepositoryProviderOperation.asResourceMappers((IResource[])new IResource[]{iProject}), new Command.LocalOption[0], ReleaseWizard.this.commentPage.getComment()).run(monitor);
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
            }
            this.checkProjects();
        }
        return true;
    }

    public void checkProjects() {
        IProject[] temp = new IProject[this.selectedProjects.length + 1];
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.selectedProjects[i] == this.buildNotesPage.getIFile().getProject()) {
                return;
            }
            ++i;
        }
        System.arraycopy(this.selectedProjects, 0, temp, 0, this.selectedProjects.length);
        temp[temp.length - 1] = this.buildNotesPage.getIFile().getProject();
        this.selectedProjects = temp;
    }

    public boolean performFinish() {
        if (!this.isProjectSelected()) {
            return false;
        }
        if (this.projectSelectionPage.isCompareButtonChecked() && !this.buildNotesOperation()) {
            return true;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CVSTag tag = new CVSTag(ReleaseWizard.this.tagPage.getTagString(), 2);
                    TagAndReleaseOperation operation = new TagAndReleaseOperation(null, ReleaseWizard.this.mapProject, (IResource[])ReleaseWizard.this.selectedProjects, tag, ReleaseWizard.this.commentPage.getComment());
                    if (ReleaseWizard.this.tagPage.isMoveButtonSelected()) {
                        operation.moveTag();
                    }
                    monitor.beginTask(Messages.getString("ReleaseWizard.21"), 100);
                    operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    if (operation.isMapFileUpdated()) {
                        try {
                            if (!ReleaseWizard.this.tagPage.isValidateButtonSelected()) return;
                            try {
                                ReleaseWizard.this.getShell().getDisplay().asyncExec(new Runnable(this){
                                    final /* synthetic */ 3 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        if (ReleaseWizard.access$5(3.access$0(this.this$1)) instanceof WizardDialog) {
                                            ((WizardDialog)ReleaseWizard.access$5(3.access$0(this.this$1))).showPage((IWizardPage)ReleaseWizard.access$6(3.access$0(this.this$1)));
                                        }
                                    }
                                });
                                ReleaseWizard.this.validateRelease((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                return;
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    } else {
                        void var5_10;
                        IStatus[] errors = operation.getErrors();
                        if (errors.length == 0) {
                            Status status = new Status(4, "org.eclipse.releng.tools", 0, Messages.getString("ReleaseWizard.22"), null);
                        } else if (errors.length == 1) {
                            IStatus iStatus = errors[0];
                        } else {
                            MultiStatus multiStatus = new MultiStatus("org.eclipse.releng.tools", 0, errors, Messages.getString("ReleaseWizard.23"), null);
                        }
                        ErrorDialog.openError((Shell)ReleaseWizard.this.getShell(), (String)Messages.getString("ReleaseWizard.24"), (String)Messages.getString("ReleaseWizard.25"), (IStatus)var5_10, (int)6);
                    }
                }

                static /* synthetic */ ReleaseWizard access$0(3 var0) {
                    return var0.ReleaseWizard.this;
                }
            });
            if (!this.defaultBeingUsed) {
                this.mapSelectionPage.saveSettings();
                this.updatePreferenceStore();
            }
            this.projectSelectionPage.saveSettings();
            this.projectComparePage.saveSettings();
            this.buildNotesPage.saveSettings();
            this.tagPage.saveSettings();
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError((Shell)this.getShell(), null, null, (Throwable)e);
            return false;
        }
    }

    private void updatePreferenceStore() {
        this.preferenceStore.setValue("useDefaultMapProject", this.mapSelectionPage.useDefaultMapProject());
        String fullPath = this.mapSelectionPage.getSelectedMapProject().getProject().getFullPath().toString();
        this.preferenceStore.setValue("defaultMapProject", fullPath);
    }

    public void setParentDialog(Dialog p) {
        this.parentDialog = p;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mapSelectionPage) {
            if (this.selectedProjects == null && this.preSelectedProjects != null) {
                this.projectSelectionPage.setSelection(this.preSelectedProjects);
                this.selectedProjects = this.preSelectedProjects;
            }
            return this.projectSelectionPage;
        }
        if (page == this.projectSelectionPage) {
            IProject[] projects = this.projectSelectionPage.getCheckedProjects();
            if (projects != null && projects.length > 0) {
                this.selectedProjects = projects;
            }
            if (this.projectSelectionPage.isCompareButtonChecked()) {
                return this.projectComparePage;
            }
            return this.tagPage;
        }
        if (page == this.tagPage) {
            if (this.tagPage.compareButtonSelected()) {
                this.mapComparePage.setTag(this.tagPage.getTagString());
                return this.mapComparePage;
            }
            if (this.tagPage.commitButtonSelected()) {
                return this.commentPage;
            }
        }
        if (page == this.mapComparePage) {
            return this.commentPage;
        }
        if (page == this.projectComparePage) {
            if (this.projectComparePage.isBuildNotesButtonChecked()) {
                this.buildNotesPage.setSyncInfoSet(this.projectComparePage.getSyncInfoSet());
                return this.buildNotesPage;
            }
            return this.tagPage;
        }
        if (page == this.buildNotesPage) {
            return this.tagPage;
        }
        return null;
    }

    public void setPreSelectedProjects(IResource[] resources) {
        if (resources.length < 1) {
            this.preSelectedProjects = null;
        } else {
            HashSet<IProject> list = new HashSet<IProject>();
            int i = 0;
            while (i < resources.length) {
                list.add(resources[i].getProject());
                ++i;
            }
            this.preSelectedProjects = list.toArray(new IProject[list.size()]);
        }
    }

    protected IProject[] performPrompting(IProject[] projects) {
        IResource[] resources;
        PromptingDialog prompt = new PromptingDialog(this.getShell(), (IResource[])projects, this.getPromptCondition((IResource[])projects), CVSUIMessages.TagAction_uncommittedChangesTitle);
        try {
            resources = prompt.promptForMultiple();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (resources.length == 0) {
            return null;
        }
        projects = new IProject[resources.length];
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IProject) {
                projects[i] = (IProject)resources[i];
            }
            ++i;
        }
        return projects;
    }

    protected IPromptCondition getPromptCondition(IResource[] resources) {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                return CVSLightweightDecorator.isDirty((IResource)resource);
            }

            public String promptMessage(IResource resource) {
                return NLS.bind((String)CVSUIMessages.TagAction_uncommittedChanges, (Object[])new String[]{resource.getName()});
            }
        };
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects;
    }

    public void updateSelectedProject() {
        this.selectedProjects = this.projectSelectionPage.getCheckedProjects();
        this.selectedProjects = this.performPrompting(this.selectedProjects);
        this.projectSelectionPage.setSelection(this.selectedProjects);
    }

    public void setSelectedProjects(IResource[] projects) {
        if (projects == null) {
            this.selectedProjects = null;
        } else {
            this.selectedProjects = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                this.selectedProjects[i] = (IProject)projects[i];
                ++i;
            }
        }
    }

    protected ProjectSelectionPage getProjectSelectionPage() {
        return this.projectSelectionPage;
    }

    private void validateRelease(IProgressMonitor monitor) throws TeamException {
        ProjectValidationDialog.validateRelease(this.getShell(), this.selectedProjects, this.mapProject.getTagsFor(this.selectedProjects), monitor);
    }

    private boolean isProjectSelected() {
        return this.selectedProjects != null && this.selectedProjects.length != 0;
    }

    public IProject[] getPreSelectedProjects() {
        return this.preSelectedProjects;
    }

    public boolean canFinish() {
        if (!this.isProjectSelected()) {
            return false;
        }
        if (!this.tagPage.isPageComplete()) {
            return false;
        }
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.validatePage) {
            return false;
        }
        return currentPage != this.tagPage || !this.tagPage.compareButtonSelected();
    }

    public MapProject getMapProject() {
        return this.mapProject;
    }

    public void broadcastMapProjectChange(MapProject m) {
        this.mapProject = m;
        this.projectSelectionPage.updateMapProject(m);
        this.projectComparePage.updateMapProject(m);
        this.mapComparePage.updateMapProject(m);
    }

    static /* synthetic */ Dialog access$5(ReleaseWizard releaseWizard) {
        return releaseWizard.parentDialog;
    }

    static /* synthetic */ ValidatePage access$6(ReleaseWizard releaseWizard) {
        return releaseWizard.validatePage;
    }
}

