/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.releng.tools.MapEntry;
import org.eclipse.releng.tools.MapFile;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class MapContentDocument
implements ITypedElement,
IStreamContentAccessor {
    private MapFile mapFile;
    private String oldContents = "";
    private String newContents = "";

    public MapContentDocument(MapFile aMapFile) {
        this.mapFile = aMapFile;
        this.initialize();
    }

    public void updateTag(IProject project, String tag) throws CVSException {
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(this.newContents.getBytes()));
        boolean match = false;
        StringBuffer buffer = new StringBuffer();
        try {
            try {
                BufferedReader aReader = new BufferedReader(new InputStreamReader(inputStream));
                String aLine = aReader.readLine();
                while (aLine != null) {
                    if (aLine.trim().length() != 0 && !aLine.startsWith("!") && !aLine.startsWith("#")) {
                        MapEntry entry = new MapEntry(aLine);
                        if (!entry.isValid()) {
                            throw new CVSException("Malformed map file line: " + aLine);
                        }
                        if (entry.isMappedTo(project)) {
                            entry.setTagName(tag);
                            aLine = entry.getMapString();
                            match = true;
                        }
                    }
                    buffer.append(aLine);
                    aLine = aReader.readLine();
                    if (aLine == null) continue;
                    buffer.append(System.getProperty("line.separator"));
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
            catch (IOException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (match) {
            this.newContents = buffer.toString();
        }
    }

    public boolean isChanged() {
        return !this.oldContents.equals(this.newContents);
    }

    public String getName() {
        return this.mapFile.getFile().getName();
    }

    public Image getImage() {
        return null;
    }

    public String getType() {
        return this.mapFile.getFile().getFileExtension();
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.getNewContent().getBytes());
    }

    public MapFile getMapFile() {
        return this.mapFile;
    }

    private String getNewContent() {
        return this.newContents;
    }

    private void initialize() {
        StringBuffer buffer = new StringBuffer();
        try {
            InputStream inputStream = this.mapFile.getFile().getContents();
            BufferedReader aReader = new BufferedReader(new InputStreamReader(inputStream));
            String aLine = aReader.readLine();
            while (aLine != null) {
                buffer.append(aLine);
                aLine = aReader.readLine();
                if (aLine == null) continue;
                buffer.append(System.getProperty("line.separator"));
            }
            this.oldContents = buffer.toString();
            this.newContents = new String(this.oldContents);
        }
        catch (CoreException e) {
            CVSUIPlugin.openError(null, null, null, (Throwable)e);
        }
        catch (IOException e) {
            CVSUIPlugin.openError(null, null, null, (Throwable)e);
        }
    }
}

