/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.xygraph.utils.LargeNumberUtils;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickLabels;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickLabels2;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickMarks;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickMarks2;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.widgets.Display;

public class DAxis
extends Axis {
    private boolean ticksIndexBased;
    private Map<Integer, Format> cachedFormats = new HashMap<Integer, Format>();
    private boolean ticksAtEnds = true;
    private boolean forceRange;
    protected boolean userDefinedFormat = false;
    private boolean axisAutoscaleTight = false;
    private static final double DEFAULT_LOG_SCALE_MIN = 1.0E-4;
    private static final double ZERO_RANGE_LOWEST_FRACTION = Math.pow(2.0, -53.0);

    public DAxis() {
        this(null, false);
    }

    public DAxis(String title, boolean yAxis) {
        super(title, yAxis);
    }

    @Override
    protected LinearScaleTickLabels createLinearScaleTickLabels() {
        return new LinearScaleTickLabels2(this);
    }

    @Override
    protected LinearScaleTickMarks createLinearScaleTickMarks() {
        return new LinearScaleTickMarks2(this);
    }

    public int calculateSpan(Object obj) {
        Dimension extent = this.getDimension(obj);
        if (this.isHorizontal()) {
            return extent.width;
        }
        return extent.height;
    }

    @Override
    public int getMargin() {
        if (this.isDirty()) {
            this.setMargin(this.getTicksProvider().getHeadMargin());
        }
        return this.getMargin(false);
    }

    public double getScaling() {
        int length = this.getLength();
        int margin = this.getMargin();
        if (this.isLogScaleEnabled()) {
            return (Math.log10(this.max) - Math.log10(this.min)) / (double)(length - 2 * margin);
        }
        return (this.max - this.min) / (double)(length - 2 * margin);
    }

    @Override
    protected void layout() {
        this.figureLayout();
        this.layoutTicks();
        this.fireRevalidated();
    }

    protected void layoutTicks() {
        this.updateTick();
        Rectangle area = this.getClientArea();
        LinearScaleTickLabels tickLabels = this.getScaleTickLabels();
        LinearScaleTickMarks tickMarks = this.getScaleTickMarks();
        if (this.isHorizontal()) {
            if (this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
                tickLabels.setBounds(new Rectangle(area.x, area.y + 6 + 2, area.width, area.height - 6));
                tickMarks.setBounds(area);
            } else {
                tickLabels.setBounds(new Rectangle(area.x, area.y + area.height - 6 - tickLabels.getTickLabelMaxHeight() - 2, area.width, tickLabels.getTickLabelMaxHeight()));
                tickMarks.setBounds(new Rectangle(area.x, area.y + area.height - 6, area.width, 6));
            }
        } else if (this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
            tickLabels.setBounds(new Rectangle(area.x + area.width - 6 - tickLabels.getTickLabelMaxLength() - 2, area.y, tickLabels.getTickLabelMaxLength(), area.height));
            tickMarks.setBounds(new Rectangle(area.x + area.width - 6 - 1, area.y, 7, area.height));
        } else {
            tickLabels.setBounds(new Rectangle(area.x + 6 + 2, area.y, tickLabels.getTickLabelMaxLength(), area.height));
            tickMarks.setBounds(new Rectangle(area.x, area.y, 6, area.height));
        }
    }

    public void setTicksIndexBased(boolean isTicksIndexBased) {
        if (this.ticksIndexBased != isTicksIndexBased) {
            ((LinearScaleTickLabels2)this.getScaleTickLabels()).setTicksIndexBased(isTicksIndexBased);
        }
        this.ticksIndexBased = isTicksIndexBased;
    }

    public boolean isTicksIndexBased() {
        return this.ticksIndexBased;
    }

    @Override
    public String format(Object obj) {
        return this.format(obj, 0);
    }

    @Override
    public void updateTick() {
        if (this.isDirty()) {
            this.setLength(this.isHorizontal() ? this.getClientArea().width : this.getClientArea().height);
            int length = this.getLength();
            int margin = this.getMargin();
            if (length > 2 * margin) {
                Range r = this.getScaleTickLabels().update(length - 2 * margin);
                if (r != null && !r.equals(this.getRange()) && !this.forceRange) {
                    this.setLocalRange(r);
                } else {
                    this.setLocalRange(null);
                }
            }
            this.setDirty(false);
        }
    }

    public String format(Object obj, int extraDP) {
        if (extraDP < 0) {
            throw new IllegalArgumentException("Number of extra decimal places must be non-negative");
        }
        String formatPattern = this.getFormatPattern();
        boolean autoFormat = this.isAutoFormat();
        if (this.cachedFormats.get(extraDP) == null) {
            if (this.isDateEnabled()) {
                if (autoFormat || formatPattern == null || formatPattern.equals("") || formatPattern.equals(this.default_decimal_format) || formatPattern.equals("0.####E0")) {
                    formatPattern = "yyyy-MM-dd\nHH:mm:ss";
                    int timeUnit = this.getTimeUnit();
                    double length = Math.abs(this.max - this.min);
                    formatPattern = length <= 1000.0 || timeUnit == 14 ? "HH:mm:ss.SSS" : (length <= 3600000.0 || timeUnit == 13 ? "HH:mm:ss" : (length <= 8.64E7 || timeUnit == 12 ? "HH:mm" : (length <= 6.048E8 || timeUnit == 11 ? "dd HH:mm" : (length <= 2.592E9 || timeUnit == 5 ? "MMMMM d" : (length <= 3.1536E10 || timeUnit == 2 ? "yyyy MMMMM" : "yyyy")))));
                    if (formatPattern == null || formatPattern.equals("")) {
                        autoFormat = true;
                    }
                }
                this.internalSetFormatPattern(formatPattern);
                this.cachedFormats.put(extraDP, new SimpleDateFormat(formatPattern));
            } else {
                if (formatPattern == null || formatPattern.isEmpty() || formatPattern.equals(this.default_decimal_format) || formatPattern.equals("yyyy-MM-dd\nHH:mm:ss")) {
                    formatPattern = this.getAutoFormat(this.min, this.max);
                    this.internalSetFormatPattern(formatPattern);
                    if (formatPattern == null || formatPattern.equals("")) {
                        autoFormat = true;
                    }
                }
                String ePattern = formatPattern;
                if (extraDP > 0) {
                    int e = formatPattern.lastIndexOf(69);
                    StringBuilder temp = new StringBuilder(e == -1 ? formatPattern : formatPattern.substring(0, e));
                    int i = 0;
                    while (i < extraDP) {
                        temp.append('#');
                        ++i;
                    }
                    if (e != -1) {
                        temp.append(formatPattern.substring(e));
                    }
                    ePattern = temp.toString();
                }
                this.cachedFormats.put(extraDP, new DecimalFormat(ePattern));
            }
            this.internalSetAutoFormat(autoFormat);
        }
        if (this.isDateEnabled() && obj instanceof Number) {
            return this.cachedFormats.get(extraDP).format(new Date(((Number)obj).longValue()));
        }
        return this.cachedFormats.get(extraDP).format(obj);
    }

    protected String getAutoFormat(double min, double max) {
        ITicksProvider ticks = this.getTicksProvider();
        if (ticks == null) {
            if (max != 0.0 && Math.abs(Math.log10(Math.abs(max))) >= 4.0 || min != 0.0 && Math.abs(Math.log10(Math.abs(min))) >= 4.0) {
                return "0.####E0";
            }
            return this.default_decimal_format;
        }
        return ticks.getDefaultFormatPattern(min, max);
    }

    @Override
    public void setDateEnabled(boolean dateEnabled) {
        this.cachedFormats.clear();
        super.setDateEnabled(dateEnabled);
    }

    @Override
    public void setFormatPattern(String formatPattern) {
        this.userDefinedFormat = true;
        this.setFormat(formatPattern);
    }

    private void setFormat(String formatPattern) {
        this.cachedFormats.clear();
        super.setFormatPattern(formatPattern);
    }

    @Override
    public void setRange(double lower, double upper) {
        this.internalSetRange(lower, upper, false);
    }

    private void internalSetRange(double lower, double upper, boolean ticksAtEnd) {
        Range old_range = this.getRange();
        if (old_range.getLower() == lower && old_range.getUpper() == upper) {
            return;
        }
        this.setTicksAtEnds(ticksAtEnd);
        if (Double.isNaN(lower) || Double.isNaN(upper) || Double.isInfinite(lower) || Double.isInfinite(upper)) {
            throw new IllegalArgumentException("Illegal range: lower=" + lower + ", upper=" + upper);
        }
        boolean bl = this.forceRange = lower == upper;
        if (this.forceRange) {
            double l;
            double h;
            double delta = lower == 0.0 ? 1.0 : Math.abs(lower);
            double limit = delta * ZERO_RANGE_LOWEST_FRACTION;
            do {
                h = upper + (delta /= 2.0);
                l = lower - delta;
            } while ((Double.isInfinite(h) || Double.isInfinite(l)) && delta > limit);
            if (Double.isInfinite(h)) {
                lower = l - delta;
            }
            if (Double.isInfinite(l)) {
                upper = h + delta;
            } else {
                upper = h;
                lower = l;
            }
        }
        if (this.isLogScaleEnabled()) {
            if (upper <= 0.0) {
                upper = 100.0;
            }
            if (lower <= 0.0) {
                lower = 1.0E-4 * upper;
            }
        }
        this.min = lower;
        this.max = upper;
        this.internalSetRange(new Range(this.min, this.max));
        this.cachedFormats.clear();
        this.setDirty(true);
        this.revalidate();
        this.repaint();
        this.fireAxisRangeChanged(old_range, this.getRange());
    }

    @Override
    public void setAutoFormat(boolean autoFormat) {
        if (autoFormat) {
            this.cachedFormats.clear();
        }
        super.setAutoFormat(autoFormat);
    }

    @Override
    public void setLogScale(boolean enabled) throws IllegalStateException {
        boolean cur = this.isLogScaleEnabled();
        if (cur == enabled) {
            return;
        }
        if (enabled) {
            if (this.min == 0.0 && this.max == 100.0) {
                this.min = 1.0E-4;
                this.max = 100.0;
            }
            if (this.max <= 0.0) {
                this.max = 100.0;
            }
            if (this.min <= 0.0) {
                this.min = 1.0E-4 * this.max;
            }
            if (this.max <= this.min) {
                this.max = this.min + 100.0;
            }
        } else if (this.min == 1.0E-4 && this.max == 100.0) {
            this.min = 0.0;
            this.max = 100.0;
        }
        this.internalSetLogScaleEnabled(enabled);
        this.setTicksAtEnds(true);
        this.internalSetRange(new Range(this.min, this.max));
        this.setDirty(true);
        this.revalidate();
        this.repaint();
        final IXYGraph xyGraph = this.getXYGraph();
        if (cur != enabled && xyGraph != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    xyGraph.performAutoScale();
                    xyGraph.getPlotArea().layout();
                    xyGraph.revalidate();
                    xyGraph.repaint();
                }
            });
        }
        this.setTicksAtEnds(true);
    }

    @Override
    public boolean performAutoScale(boolean force) {
        double newMin;
        boolean upperChanged;
        if (this.getTraceList().size() <= 0 || !force && !this.getAutoScale()) {
            return false;
        }
        Range range = this.getTraceDataRange();
        if (range == null) {
            return false;
        }
        double dataMin = range.getLower();
        double dataMax = range.getUpper();
        double axisMax = this.getRange().getUpper();
        double axisMin = this.getRange().getLower();
        if (this.rangeIsUnchanged(dataMin, dataMax, axisMin, axisMax) || Double.isInfinite(dataMin) || Double.isInfinite(dataMax) || Double.isNaN(dataMin) || Double.isNaN(dataMax)) {
            return false;
        }
        double f = Math.max(LargeNumberUtils.maxMagnitude(axisMin, axisMax), LargeNumberUtils.maxMagnitude(dataMin, dataMax));
        dataMax /= f;
        double thr = ((axisMax /= f) - (axisMin /= f)) * 0.5 * this.getAutoScaleThreshold();
        boolean lowerChanged = (dataMin /= f) - axisMin < 0.0 || dataMin - axisMin >= thr;
        boolean bl = upperChanged = axisMax - dataMax < 0.0 || axisMax - dataMax >= thr;
        if (!lowerChanged && !upperChanged) {
            return false;
        }
        double newMax = upperChanged ? dataMax : axisMax;
        double d = newMin = lowerChanged ? dataMin : axisMin;
        if (this.isInverted()) {
            double t = newMin;
            newMin = newMax;
            newMax = t;
        }
        this.internalSetRange(newMin * f, newMax * f, !this.axisAutoscaleTight);
        return true;
    }

    private boolean rangeIsUnchanged(double dataMin, double dataMax, double axisMin, double axisMax) {
        return Double.doubleToLongBits(dataMin) == Double.doubleToLongBits(axisMin) && Double.doubleToLongBits(dataMax) == Double.doubleToLongBits(axisMax);
    }

    public void clear() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (!this.getTraceList().contains(it.next())) continue;
            it.remove();
        }
        this.getTraceList().clear();
    }

    public void setAxisAutoscaleTight(boolean axisTight) {
        this.axisAutoscaleTight = axisTight;
    }

    public boolean isAxisAutoscaleTight() {
        return this.axisAutoscaleTight;
    }

    public void setTicksAtEnds(boolean ticksAtEnds) {
        this.ticksAtEnds = ticksAtEnds;
    }

    @Override
    public boolean hasTicksAtEnds() {
        return this.ticksAtEnds;
    }

    public void setHasUserDefinedFormat(boolean hasUserDefinedFormat) {
        this.userDefinedFormat = hasUserDefinedFormat;
    }

    public boolean hasUserDefinedFormat() {
        return this.userDefinedFormat;
    }
}

