/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public abstract class AbstractDataProvider
implements IDataProvider {
    protected boolean chronological = false;
    protected List<IDataProviderListener> listeners;
    protected Range xDataMinMax = null;
    protected Range yDataMinMax = null;

    public AbstractDataProvider(boolean chronological) {
        this.chronological = chronological;
        this.listeners = new ArrayList<IDataProviderListener>();
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract ISample getSample(int var1);

    @Override
    public Range getXDataMinMax() {
        return this.getXDataMinMax(false);
    }

    @Override
    public Range getYDataMinMax() {
        return this.getYDataMinMax(false);
    }

    @Override
    public synchronized Range getXDataMinMax(boolean positiveOnly) {
        if (this.getSize() <= 0) {
            return null;
        }
        this.xDataMinMax = this.getDataRange(positiveOnly, true);
        return this.xDataMinMax;
    }

    @Override
    public synchronized Range getYDataMinMax(boolean positiveOnly) {
        if (this.getSize() <= 0) {
            return null;
        }
        this.yDataMinMax = this.getDataRange(positiveOnly, false);
        return this.yDataMinMax;
    }

    public Range getDataRange(boolean positiveOnly, boolean isAxis) {
        return this.getDataRange(positiveOnly, isAxis, 0);
    }

    public Range getDataRange(boolean positiveOnly, boolean isXAxis, int lowerBound) {
        Range range = null;
        if (this.getSize() > 0) {
            double min = Double.POSITIVE_INFINITY;
            double max = positiveOnly ? 0.0 : Double.NEGATIVE_INFINITY;
            int i = lowerBound;
            while (i < this.getSize()) {
                double value;
                ISample dp = this.getSample(i);
                double d = value = isXAxis ? dp.getXValue() - dp.getXMinusError() : dp.getYValue() - dp.getYMinusError();
                if (!(positiveOnly && !(value > 0.0) || !(min > value) || value == 0.0 && positiveOnly)) {
                    min = value;
                }
                double d2 = value = isXAxis ? dp.getXValue() + dp.getXPlusError() : dp.getYValue() + dp.getYPlusError();
                if (max < value) {
                    max = value;
                }
                ++i;
            }
            if (positiveOnly && max < min) {
                max = min;
            }
            range = new Range(min, max);
        }
        return range;
    }

    public void setChronological(boolean chronological) {
        this.chronological = chronological;
    }

    @Override
    public boolean isChronological() {
        return this.chronological;
    }

    @Override
    public void addDataProviderListener(IDataProviderListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean removeDataProviderListener(IDataProviderListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireDataChange() {
        for (IDataProviderListener listener : this.listeners) {
            listener.dataChanged(this);
        }
    }
}

