/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedWavelengthSignals;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedWavelengthSignals;

public class ExtractedWavelengthSignalExtractor
implements IExtractedWavelengthSignalExtractor {
    private IChromatogramWSD chromatogram;

    public ExtractedWavelengthSignalExtractor(IChromatogramWSD chromatogram) throws ChromatogramIsNullException {
        if (chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        this.chromatogram = chromatogram;
    }

    @Override
    public IExtractedWavelengthSignals getExtractedWavelengthSignals(float startWavelength, float stopWavelength) {
        ExtractedWavelengthSignals signals = new ExtractedWavelengthSignals(this.getNumberOfScansWithWavelengths(this.chromatogram), this.chromatogram);
        for (IScan scan : this.chromatogram.getScans()) {
            IScanWSD scanWSD;
            if (!(scan instanceof IScanWSD) || (scanWSD = (IScanWSD)scan).getScanSignals().size() <= 0) continue;
            IExtractedWavelengthSignal extractedWavelengthSignal = scanWSD.getExtractedWavelengthSignal(startWavelength, stopWavelength);
            signals.add(extractedWavelengthSignal);
        }
        return signals;
    }

    @Override
    public IExtractedWavelengthSignals getExtractedWavelengthSignals() {
        ExtractedWavelengthSignals signals = new ExtractedWavelengthSignals(this.getNumberOfScansWithWavelengths(this.chromatogram), this.chromatogram);
        for (IScan scan : this.chromatogram.getScans()) {
            IScanWSD scanWSD;
            if (!(scan instanceof IScanWSD) || (scanWSD = (IScanWSD)scan).getScanSignals().size() <= 0) continue;
            IExtractedWavelengthSignal extractedWavelengthSignal = scanWSD.getExtractedWavelengthSignal();
            signals.add(extractedWavelengthSignal);
        }
        return signals;
    }

    @Override
    public IExtractedWavelengthSignals getExtractedWavelengthSignals(IChromatogramSelectionWSD chromatogramSelection) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() != this.chromatogram) {
            return new ExtractedWavelengthSignals(0, this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        return this.getExtractedWavelengthSignals(startScan, stopScan);
    }

    @Override
    public IExtractedWavelengthSignals getExtractedWavelengthSignals(int startScan, int stopScan) {
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        if (startScan < 1 && stopScan > this.getNumberOfScansWithWavelengths(this.chromatogram)) {
            return new ExtractedWavelengthSignals(0, this.chromatogram);
        }
        ExtractedWavelengthSignals extractedIonSignals = new ExtractedWavelengthSignals(startScan, stopScan, this.chromatogram);
        int scan = startScan;
        while (scan <= stopScan) {
            IScanWSD scanWSD = this.chromatogram.getSupplierScan(scan);
            if (scanWSD.getScanSignals().size() > 0) {
                IExtractedWavelengthSignal extractedWavelengthSignal = scanWSD.getExtractedWavelengthSignal();
                extractedWavelengthSignal.setRetentionTime(scanWSD.getRetentionTime());
                extractedIonSignals.add(extractedWavelengthSignal);
            }
            ++scan;
        }
        return extractedIonSignals;
    }

    private int getNumberOfScansWithWavelengths(IChromatogramWSD chromatogram) {
        int counter = 0;
        for (IScan scan : chromatogram.getScans()) {
            IScanWSD scanWSD;
            if (!(scan instanceof IScanWSD) || (scanWSD = (IScanWSD)scan).getScanSignals().size() <= 0) continue;
            ++counter;
        }
        return counter;
    }
}

