/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.dialogs;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.rcp.app.ui.provider.SelectViewContentProvider;
import org.eclipse.chemclipse.rcp.app.ui.provider.SelectViewFilter;
import org.eclipse.chemclipse.rcp.app.ui.provider.SelectViewLabelProvider;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectViewDialog
extends Dialog
implements ISelectionChangedListener {
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 300;
    private TableViewer tableViewer;
    private SelectViewFilter selectViewFilter;
    private Text text;
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    private List<MPart> parts;
    private MPart selectedPart;

    @Inject
    public SelectViewDialog(@Named(value="activeShell") Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select View");
        this.parts = this.modelService.findElements((MUIElement)this.application, null, MPart.class, null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TableItem item;
        Table table = this.tableViewer.getTable();
        int index = table.getSelectionIndex();
        if (index >= 0 && (item = table.getItem(index)).getData() instanceof MPart) {
            this.selectedPart = (MPart)item.getData();
        }
        this.validateSelection();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createViewSearchTextField(composite);
        this.createViewList(composite);
        this.validateSelection();
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
        this.selectAndActivatePart();
    }

    private void selectAndActivatePart() {
        if (this.selectedPart != null) {
            if (!this.partService.getParts().contains(this.selectedPart)) {
                this.partService.createPart(this.selectedPart.getElementId());
            }
            this.partService.showPart(this.selectedPart, EPartService.PartState.ACTIVATE);
        }
    }

    private void createViewSearchTextField(Composite parent) {
        this.text = new Text(parent, 2436);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setText("");
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SelectViewDialog.this.selectViewFilter.setSearchPattern(SelectViewDialog.this.text.getText());
                SelectViewDialog.this.tableViewer.refresh();
                SelectViewDialog.this.validateSelection();
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SelectViewDialog.this.selectViewFilter.setSearchPattern(SelectViewDialog.this.text.getText());
                SelectViewDialog.this.tableViewer.refresh();
                SelectViewDialog.this.validateSelection();
            }
        });
    }

    private void createViewList(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68356);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        Control control = this.tableViewer.getControl();
        control.setLayoutData((Object)gridData);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)ContextInjectionFactory.make(SelectViewLabelProvider.class, (IEclipseContext)this.eclipseContext));
        this.tableViewer.setContentProvider((IContentProvider)new SelectViewContentProvider());
        this.tableViewer.setInput(this.parts);
        this.selectViewFilter = new SelectViewFilter();
        this.selectViewFilter.setCaseInsensitive(true);
        this.tableViewer.addFilter((ViewerFilter)this.selectViewFilter);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectViewDialog.this.okPressed();
            }
        });
    }

    private void validateSelection() {
        Button buttonOK = this.getButton(0);
        if (buttonOK == null) {
            return;
        }
        Table table = this.tableViewer.getTable();
        int index = table.getSelectionIndex();
        if (index >= 0) {
            TableItem item = table.getItem(index);
            if (item.getData() instanceof MPart) {
                buttonOK.setEnabled(true);
            } else {
                buttonOK.setEnabled(false);
            }
        } else {
            buttonOK.setEnabled(false);
        }
    }
}

