/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.test;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.TestSuite;
import org.osgi.framework.Bundle;

public class TestAssembler {
    public static final String FRAGMENT_HOST = "Fragment-Host";
    private Bundle[] bundles;

    public TestAssembler(Bundle[] bundles) {
        this.bundles = bundles;
    }

    public void assembleTests(TestSuite testSuite, String bundleName, String packageName, String filter) {
        Bundle[] bundleArray = this.bundles;
        int n = this.bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (!this.isFragment(bundle) && bundle.getSymbolicName().startsWith(bundleName)) {
                List<Class> testClasses = this.getTestClasses(bundle, packageName, filter);
                for (Class clazz : testClasses) {
                    testSuite.addTestSuite(clazz);
                }
            }
            ++n2;
        }
    }

    private List<Class> getTestClasses(Bundle bundle, String packageName, String filter) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        Enumeration testClassNames = bundle.findEntries("/", String.valueOf(filter) + ".class", true);
        if (testClassNames != null) {
            while (testClassNames.hasMoreElements()) {
                String testClassPath = ((URL)testClassNames.nextElement()).getPath();
                int packageNameStart = (testClassPath = testClassPath.replace('/', '.')).indexOf(packageName);
                if (packageNameStart == -1) continue;
                String testClassName = testClassPath.substring(packageNameStart);
                testClassName = testClassName.substring(0, testClassName.length() - 6);
                Class testClass = null;
                try {
                    testClass = bundle.loadClass(testClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class was not loadable: " + testClassName, e);
                }
                if (Modifier.isAbstract(testClass.getModifiers())) continue;
                testClasses.add(testClass);
            }
        }
        return testClasses;
    }

    private boolean isFragment(Bundle bundle) {
        Enumeration headerKeys = bundle.getHeaders().keys();
        while (headerKeys.hasMoreElements()) {
            if (!headerKeys.nextElement().toString().equals(FRAGMENT_HOST)) continue;
            return true;
        }
        return false;
    }
}

