/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.openchromx.internal.support;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.supplier.openchromx.model.VendorIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public class IonSupport {
    private static final Logger logger = Logger.getLogger(IonSupport.class);
    private static final Pattern ionPattern = Pattern.compile("(\\d+\\.\\d+),(\\d+\\.\\d+)");
    private static final String valueDelimiter = ",";
    private static final String ionDelimiter = " ";

    public static String encodeIons(IVendorMassSpectrum massSpectrum) {
        List ions = massSpectrum.getIons();
        StringBuilder builder = new StringBuilder();
        for (IIon ion : ions) {
            builder.append(ion.getIon());
            builder.append(valueDelimiter);
            builder.append(ion.getAbundance());
            builder.append(ionDelimiter);
        }
        return builder.toString();
    }

    public static void decodeIons(IVendorMassSpectrum supplierMassSpectrum, String encodedIons) {
        String decodedIons = encodedIons;
        Matcher matcher = ionPattern.matcher(decodedIons);
        while (matcher.find()) {
            try {
                String ions = matcher.group(0);
                String[] values = ions.split(valueDelimiter);
                float ion = Float.parseFloat(values[0]);
                float abundance = Float.parseFloat(values[1]);
                VendorIon supplierIon = new VendorIon(ion, abundance);
                supplierMassSpectrum.addIon((IIon)supplierIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }
}

