/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.model;

import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.supplier.csv.model.IVendorIon;
import org.eclipse.chemclipse.msd.model.core.AbstractScanIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public class VendorIon
extends AbstractScanIon
implements IVendorIon {
    private static final long serialVersionUID = -8157753037973736403L;
    public static final int BINARY_ION_LENGTH_IN_BYTES = 4;
    public static final float MIN_ABUNDANCE = Float.MIN_VALUE;
    public static final float MAX_ABUNDANCE = Float.MAX_VALUE;
    public static final double MIN_ION = 1.0;
    public static final double MAX_ION = 50000.0;

    public VendorIon(double ion) throws IonLimitExceededException {
        super(ion);
    }

    public VendorIon(double ion, boolean ignoreAbundanceLimit) throws IonLimitExceededException {
        super(ion);
        this.setIgnoreAbundanceLimit(ignoreAbundanceLimit);
    }

    public VendorIon(double ion, float abundance) throws AbundanceLimitExceededException, IonLimitExceededException {
        super(ion, abundance);
    }

    public float getMaxPossibleAbundanceValue() {
        return Float.MAX_VALUE;
    }

    public double getMaxPossibleIonValue() {
        return 50000.0;
    }

    public float getMinPossibleAbundanceValue() {
        return Float.MIN_VALUE;
    }

    public double getMinPossibleIonValue() {
        return 1.0;
    }
}

