/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import org.eclipse.chemclipse.model.quantitation.IInternalStandard;

public class InternalStandard
implements IInternalStandard {
    private String name = "";
    private double concentration;
    private String concentrationUnit;
    private double responseFactor;
    private String chemicalClass = "";

    public InternalStandard(String name, double concentration, String concentrationUnit, double responseFactor) {
        this.name = name;
        this.concentration = concentration;
        this.concentrationUnit = concentrationUnit;
        this.responseFactor = responseFactor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            name = "";
        } else {
            this.name = name;
        }
    }

    @Override
    public double getConcentration() {
        return this.concentration;
    }

    @Override
    public String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    @Override
    public double getResponseFactor() {
        return this.responseFactor;
    }

    @Override
    public String getChemicalClass() {
        return this.chemicalClass;
    }

    @Override
    public void setChemicalClass(String chemicalClass) {
        this.chemicalClass = chemicalClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.concentration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.concentrationUnit == null ? 0 : this.concentrationUnit.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalStandard other = (InternalStandard)obj;
        if (Double.doubleToLongBits(this.concentration) != Double.doubleToLongBits(other.concentration)) {
            return false;
        }
        if (this.concentrationUnit == null ? other.concentrationUnit != null : !this.concentrationUnit.equals(other.concentrationUnit)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "InternalStandard [name=" + this.name + ", concentration=" + this.concentration + ", concentrationUnit=" + this.concentrationUnit + ", responseFactor=" + this.responseFactor + ", chemicalClass=" + this.chemicalClass + "]";
    }
}

