/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.chemclipse.model.core.IChromatogramPeaks;
import org.eclipse.chemclipse.model.core.IPeak;

public final class PeakRTMap<T extends IPeak>
implements Serializable,
IChromatogramPeaks<T> {
    private static final long serialVersionUID = 6339698016420166069L;
    private int peakcount;
    private final TreeMap<Integer, Collection<T>> internalMap = new TreeMap();

    @Override
    public void addPeak(T peak) {
        Integer rt = PeakRTMap.getKey(peak);
        Collection<T> list = this.internalMap.get(rt);
        if (list == null) {
            list = new LinkedHashSet<T>();
            this.internalMap.put(rt, list);
        }
        if (list.add(peak)) {
            ++this.peakcount;
        }
    }

    @Override
    public void removePeak(T peakToRemove) {
        Integer rt = PeakRTMap.getKey(peakToRemove);
        Collection<T> list = this.internalMap.get(rt);
        if (list != null) {
            Iterator<T> iterator = list.iterator();
            while (iterator.hasNext()) {
                IPeak other = (IPeak)iterator.next();
                if (!other.equals(peakToRemove)) continue;
                iterator.remove();
                --this.peakcount;
                break;
            }
            if (list.isEmpty()) {
                this.internalMap.remove(rt);
            }
        }
    }

    @Override
    public List<T> getPeaks() {
        return PeakRTMap.collectPeaks(this.internalMap.values());
    }

    @Override
    public List<T> getPeaks(int startRetentionTime, int stopRetentionTime) {
        return PeakRTMap.collectPeaks(this.internalMap.subMap(startRetentionTime, true, stopRetentionTime, true).values());
    }

    private static <T extends IPeak> List<T> collectPeaks(Collection<Collection<T>> values) {
        ArrayList<T> list = new ArrayList<T>();
        for (Collection<T> value : values) {
            list.addAll(value);
        }
        Collections.sort(list, IPeak.COMPARATOR_RT_MAX);
        return list;
    }

    private static Integer getKey(IPeak peak) {
        return peak.getPeakModel().getRetentionTimeAtPeakMaximum();
    }

    @Override
    public void removeAllPeaks() {
        this.internalMap.clear();
        this.peakcount = 0;
    }

    @Override
    public int getNumberOfPeaks() {
        return this.peakcount;
    }

    @Override
    public void removePeaks(List<T> peaksToDelete) {
        for (IPeak peak : peaksToDelete) {
            this.removePeak(peak);
        }
    }
}

