/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.baseline.IChromatogramBaseline;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogramIntegrationSupport;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IChromatogramPeaks;
import org.eclipse.chemclipse.model.core.IChromatogramProcessorSupport;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.core.SegmentedMeasurement;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.updates.IUpdater;
import org.eclipse.chemclipse.model.versioning.IChromatogramVersioning;
import org.eclipse.chemclipse.support.history.ISupplierEditHistory;
import org.eclipse.core.runtime.IAdaptable;

public interface IChromatogram<T extends IPeak>
extends SegmentedMeasurement,
IMeasurement,
IChromatogramOverview,
IAdaptable,
IChromatogramPeaks<T>,
IChromatogramVersioning,
ISupplierEditHistory,
IChromatogramBaseline,
IUpdater,
IChromatogramIntegrationSupport,
IChromatogramProcessorSupport,
ITargetSupplier {
    public static final String DEFAULT_CHROMATOGRAM_NAME = "Chromatogram";
    public static final int MIN_SCANDELAY = 0;
    public static final int MAX_SCANDELAY = 216000000;
    public static final int MIN_SCANINTERVAL = 1;
    public static final int MAX_SCANINTERVAL = 3600000;
    public static final float MIN_SCANS_PER_SECOND = 0.1f;
    public static final float MAX_SCANS_PER_SECOND = 20.0f;

    public void setConverterId(String var1);

    public String getConverterId();

    public void addScan(IScan var1);

    public void addScans(List<IScan> var1);

    public IScan getScan(int var1);

    public List<IScan> getScans();

    public void removeScan(int var1);

    public void removeScans(int var1, int var2);

    public void recalculateTheNoiseFactor();

    public float getSignalToNoiseRatio(float var1);

    public String extractNameFromDirectory(String var1, String var2);

    public String extractNameFromFile(String var1);

    public List<IChromatogram<?>> getReferencedChromatograms();

    public void addReferencedChromatogram(IChromatogram<?> var1);

    public void removeReferencedChromatogram(IChromatogram<?> var1);

    public void removeAllReferencedChromatograms();

    public void setUnloaded();

    public boolean isUnloaded();

    public boolean containsScanCycles();

    public List<IScan> getScanCycleScans(int var1);

    public IMethod getMethod();

    public ISeparationColumnIndices getSeparationColumnIndices();

    public void setSeparationColumnIndices(ISeparationColumnIndices var1);

    @Override
    default public File getFile() {
        return null;
    }

    public void setDirty(boolean var1);

    default public void defineAnalysisSegment(IScanRange range) {
        this.defineAnalysisSegment(range, Collections.emptyList());
    }

    public void defineAnalysisSegment(IScanRange var1, Collection<? extends IAnalysisSegment> var2);

    public void removeAnalysisSegment(IAnalysisSegment var1);

    public void updateAnalysisSegment(IAnalysisSegment var1, IScanRange var2);

    default public void clearAnalysisSegments() {
        IAnalysisSegment[] segments;
        IAnalysisSegment[] iAnalysisSegmentArray = segments = this.getAnalysisSegments().toArray(new IAnalysisSegment[0]);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            IAnalysisSegment segment = iAnalysisSegmentArray[n2];
            this.removeAnalysisSegment(segment);
            ++n2;
        }
    }
}

