/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.swt;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.internal.editingsupport.SampleQuantCheckBoxEditingSupport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.internal.provider.SampleQuantLabelProvider;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.internal.provider.SampleQuantTableComparator;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;

public class SampleQuantTableViewerUI
extends ExtendedTableViewer {
    public static final int INDEX_TYPE = 7;
    public static final int INDEX_MIN_MATCH_QUALITY = 8;
    public static final int INDEX_MATCH_QUALITY = 9;
    public static final int INDEX_OK = 10;
    private String[] titles = new String[]{"ID", "CAS#", "Name", "Max Scan", "Concentration", "Unit", "Misc", "Type", "Min Match Quality", "Match Quality", "OK"};
    private int[] bounds = new int[]{60, 110, 150, 50, 50, 50, 100, 30, 50, 50, 30};
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public SampleQuantTableViewerUI(Composite parent) {
        super(parent);
        this.createColumns();
    }

    public SampleQuantTableViewerUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider((IBaseLabelProvider)new SampleQuantLabelProvider());
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator((ViewerComparator)new SampleQuantTableComparator());
        this.setCellColorProvider();
        this.setEditingSupport();
    }

    private void setCellColorProvider() {
        List tableViewerColumns = this.getTableViewerColumns();
        TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(9);
        if (tableViewerColumn != null) {
            tableViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell != null) {
                        ISampleQuantSubstance sampleQuantSubstance = (ISampleQuantSubstance)cell.getElement();
                        if (!sampleQuantSubstance.getType().equals("ISTD")) {
                            double matchQuality = sampleQuantSubstance.getMatchQuality();
                            cell.setText(SampleQuantTableViewerUI.this.decimalFormat.format(matchQuality));
                            if (!sampleQuantSubstance.getType().equals("ISTD")) {
                                if (!sampleQuantSubstance.isValidated()) {
                                    cell.setBackground(Colors.YELLOW);
                                    cell.setForeground(Colors.BLACK);
                                } else {
                                    cell.setBackground(Colors.GREEN);
                                    cell.setForeground(Colors.BLACK);
                                }
                            }
                        }
                        super.update(cell);
                    }
                }
            });
        }
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(10);
        tableViewerColumn.setEditingSupport((EditingSupport)new SampleQuantCheckBoxEditingSupport((TableViewer)this));
    }
}

