/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.StandardsReader;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.RetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.SeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;

public class RetentionIndexExtractor {
    public ISeparationColumnIndices extract(IChromatogram chromatogram) {
        StandardsReader standardsReader = new StandardsReader();
        Map<String, Integer> nameIndexMap = standardsReader.getNameIndexMap();
        SeparationColumnIndices separationColumnIndices = new SeparationColumnIndices();
        separationColumnIndices.setSeparationColumn(chromatogram.getSeparationColumnIndices().getSeparationColumn());
        List<? extends IPeak> peaks = this.getPeaks(chromatogram);
        for (IPeak iPeak : peaks) {
            String name;
            Set peakTargets = iPeak.getTargets();
            if (peakTargets.size() <= 0 || !nameIndexMap.containsKey(name = ((IIdentificationTarget)new ArrayList(peakTargets).get(0)).getLibraryInformation().getName().trim())) continue;
            int retentionTime = iPeak.getPeakModel().getRetentionTimeAtPeakMaximum();
            float retentionIndex = nameIndexMap.get(name).intValue();
            RetentionIndexEntry retentionIndexEntry = new RetentionIndexEntry(retentionTime, retentionIndex, name);
            separationColumnIndices.put((IRetentionIndexEntry)retentionIndexEntry);
        }
        return separationColumnIndices;
    }

    private List<? extends IPeak> getPeaks(IChromatogram chromatogram) {
        ArrayList peaks = new ArrayList();
        peaks.addAll(chromatogram.getPeaks());
        return peaks;
    }
}

