/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.chemclipse.model.core.IPeak;

public class PeakGroup<T extends IPeak> {
    private final Map<Integer, T> peakMap = new HashMap<Integer, T>();

    public void addPeak(T peak, int index) {
        this.peakMap.put(index, peak);
    }

    public void merge(PeakGroup<T> other) {
        this.peakMap.putAll(other.peakMap);
        other.peakMap.clear();
    }

    public boolean intersects(PeakGroup<T> other) {
        if (other.peakMap.isEmpty()) {
            return false;
        }
        for (Integer index : other.peakMap.keySet()) {
            if (!this.peakMap.containsKey(index)) continue;
            return true;
        }
        return false;
    }

    public T getMaxPeak(Comparator<T> comparator) {
        return (T)((IPeak)this.peakMap.values().stream().max(comparator).orElseThrow(NoSuchElementException::new));
    }

    public String toString() {
        return this.peakMap.keySet().toString();
    }

    public boolean isEmpty() {
        return this.peakMap.isEmpty();
    }

    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.peakMap.values());
    }
}

