/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultsLabelProvider
extends AbstractChemClipseLabelProvider {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ICombinedMassSpectrum) {
            ICombinedMassSpectrum combinedMassSpectrum = (ICombinedMassSpectrum)element;
            switch (columnIndex) {
                case 0: {
                    text = Integer.toString(combinedMassSpectrum.getStartScan());
                    break;
                }
                case 1: {
                    text = Integer.toString(combinedMassSpectrum.getStopScan());
                    break;
                }
                case 2: {
                    text = this.decimalFormat.format((double)combinedMassSpectrum.getStartRetentionTime() / 60000.0);
                    break;
                }
                case 3: {
                    text = this.decimalFormat.format((double)combinedMassSpectrum.getStopRetentionTime() / 60000.0);
                    break;
                }
                case 4: {
                    text = this.decimalFormat.format(combinedMassSpectrum.getStartRetentionIndex());
                    break;
                }
                case 5: {
                    text = this.decimalFormat.format(combinedMassSpectrum.getStopRetentionIndex());
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16");
    }
}

