/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.FeatureDataMatrix;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISamplesPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider.FeatureComparator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider.FeatureEditingSupport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider.FeatureLabelProvider;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider.FeatureListFilter;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class FeatureListUI
extends ExtendedTableViewer {
    private static final String[] TITLES = FeatureLabelProvider.TITLES;
    private static final int[] BOUNDS = FeatureLabelProvider.BOUNDS;
    private final ITableLabelProvider labelProvider = new FeatureLabelProvider();
    private final ViewerComparator comparator = new FeatureComparator();
    private final FeatureListFilter listFilter = new FeatureListFilter();

    public FeatureListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumnsDefault();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.listFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void setInput(EvaluationPCA evaluationPCA) {
        ISamplesPCA samples;
        boolean createDefault = true;
        if (evaluationPCA != null && (samples = evaluationPCA.getSamples()) != null) {
            createDefault = false;
            FeatureDataMatrix featureDataMatrix = new FeatureDataMatrix(samples);
            this.createColumnsSpecific(featureDataMatrix);
            super.setInput((Object)featureDataMatrix.getFeatures());
        }
        if (createDefault) {
            super.setInput(null);
            this.createColumnsDefault();
        }
    }

    private void createColumnsDefault() {
        this.createColumns(TITLES, BOUNDS, this.labelProvider, this.comparator);
    }

    private void createColumnsSpecific(FeatureDataMatrix featureDataMatrix) {
        String variableName = featureDataMatrix.getVariableName();
        List sampleNames = featureDataMatrix.getSampleNames();
        ArrayList<Object> titleList = new ArrayList<Object>();
        ArrayList<Integer> boundList = new ArrayList<Integer>();
        int i = 0;
        while (i < TITLES.length) {
            Object title = TITLES[i];
            if ("Variable".equals(title)) {
                title = variableName;
            }
            titleList.add(title);
            boundList.add(BOUNDS[i]);
            ++i;
        }
        for (String sampleName : sampleNames) {
            titleList.add(sampleName);
            boundList.add(100);
        }
        String[] titles = titleList.toArray(new String[titleList.size()]);
        int size = boundList.size();
        int[] bounds = new int[size];
        int i2 = 0;
        while (i2 < size) {
            bounds[i2] = (Integer)boundList.get(i2);
            ++i2;
        }
        super.setInput(null);
        this.createColumns(titles, bounds, this.labelProvider, this.comparator);
    }

    private void createColumns(String[] titles, int[] bounds, ITableLabelProvider labelProvider, ViewerComparator comparator) {
        this.createColumns(titles, bounds);
        this.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator(comparator);
        this.setFilters(new ViewerFilter[]{this.listFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (this.isEditable(label)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new FeatureEditingSupport(this, label));
            }
            ++i;
        }
    }

    private boolean isEditable(String label) {
        if ("Use".equals(label)) {
            return true;
        }
        if ("Classification".equals(label)) {
            return true;
        }
        return "Description".equals(label);
    }
}

