/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.quickstart;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IExtractionData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISamplesPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Samples;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.handlers.CreatePcaEvaluation;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.IInputWizard;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardTile
implements TileDefinition {
    private static final Logger logger = Logger.getLogger(WizardTile.class);
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 600;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, IEclipseContext context) throws InvocationTargetException, InterruptedException {
        ISamplesPCA samples;
        IInputWizard wizard = this.createWizard();
        BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(shell, wizard);
        wizardDialog.setMinimumPageSize(500, 600);
        final AtomicReference evaluation = new AtomicReference();
        if (wizardDialog.open() == 0) {
            final IAnalysisSettings analysisSettings = wizard.getAnalysisSettings();
            analysisSettings.setPreprocessingSettings(wizard.getPreprocessingSettings());
            analysisSettings.setFilterSettings(wizard.getFilterSettings());
            final IExtractionData extractionData = wizard.getExtractionData();
            if (extractionData != null) {
                ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(wizardDialog.getShell());
                monitorDialog.setCancelable(true);
                monitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Samples samples = extractionData.process(monitor);
                        samples.setAnalysisSettings(analysisSettings);
                        evaluation.set(samples);
                    }
                });
            }
        }
        if ((samples = (ISamplesPCA)evaluation.get()) != null) {
            CreatePcaEvaluation.createPart(samples, context, null);
        } else {
            logger.warn((Object)"Failed to create PCA analysis.");
        }
    }

    public String getPreferredPerspective() {
        return "org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.perspective";
    }

    public String getContext() {
        return "pca-quickstart-default-wizard";
    }

    protected abstract IInputWizard createWizard();
}

