/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support.InputFilesTable;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class DataInputPageWizard
extends WizardPage {
    private static final String FILES = "Input Files: ";
    private List<IDataInputEntry> dataInputEntries = new ArrayList<IDataInputEntry>();
    private InputFilesTable inputFilesTable;
    private Label countFiles;

    public DataInputPageWizard(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void addInputFiles(List<IDataInputEntry> addInput) {
        HashMap uniqueInputs = new HashMap();
        this.dataInputEntries.forEach(e -> {
            IDataInputEntry iDataInputEntry = uniqueInputs.put(e.getName(), e);
        });
        addInput.forEach(e -> {
            IDataInputEntry iDataInputEntry = uniqueInputs.put(e.getName(), e);
        });
        this.dataInputEntries.clear();
        this.dataInputEntries.addAll(uniqueInputs.values());
        this.update();
    }

    public List<IDataInputEntry> getUniqueDataInputEnties() {
        return this.dataInputEntries;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.inputFilesTable = this.createInputFilesTable(composite);
        this.countFiles = this.createLabel(composite, "Input Files: 0");
        this.createToolbarBottom(composite);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.update();
        }
        super.setVisible(visible);
    }

    protected abstract void addFiles();

    protected void update() {
        this.inputFilesTable.update();
        this.redrawCountFiles();
        this.setPageComplete(!this.dataInputEntries.isEmpty());
    }

    private InputFilesTable createInputFilesTable(Composite parent) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        gridData.heightHint = 300;
        this.inputFilesTable = new InputFilesTable(parent, gridData);
        this.inputFilesTable.setDataInputEntries(this.dataInputEntries);
        return this.inputFilesTable;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(256));
        label.setText(text);
        return label;
    }

    private void createToolbarBottom(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonAdd(composite);
        this.createButtonRemove(composite);
        this.createButtonRemoveAll(composite);
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add new file(s).");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataInputPageWizard.this.addFiles();
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Remove selected file(s).");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataInputPageWizard.this.inputFilesTable.removeSelection();
                DataInputPageWizard.this.update();
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Remove all file(s).");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete_all.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataInputPageWizard.this.dataInputEntries.clear();
                DataInputPageWizard.this.update();
            }
        });
        return button;
    }

    private void redrawCountFiles() {
        this.countFiles.setText(FILES + Integer.toString(this.dataInputEntries.size()));
    }
}

