/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;

public class ScorePlot3DSettings {
    private double axisMaxX;
    private double axisMaxY;
    private double axisMaxZ;
    private double axisMinX;
    private double axisMinY;
    private double axisMinZ;
    private Map<String, Color> groups = new LinkedHashMap<String, Color>();
    private double lineSpacingX;
    private double lineSpacingY;
    private double lineSpacingZ;
    private int maxNumberLine = 5;
    private double maxX = 100.0;
    private double maxY = 100.0;
    private double maxZ = 100.0;
    private double minX = -100.0;
    private double minY = -100.0;
    private double minZ = -100.0;
    private int pcX = 1;
    private int pcY = 2;
    private int pcZ = 3;
    private double scaleX;
    private double scaleY;
    private double scaleZ;
    private double shiftX;
    private double shiftY;
    private double shiftZ;

    public ScorePlot3DSettings(int scale) {
        ScorePlot3DSettings.setAxes(this, scale);
    }

    public static void setAxesEnhanced(ScorePlot3DSettings settings, int scale) {
        int numberLines = settings.getMaxNumberLine();
        double[] X = ScorePlot3DSettings.setAxes(settings.minX, settings.maxX, numberLines);
        double[] Y = ScorePlot3DSettings.setAxes(settings.minY, settings.maxY, numberLines);
        double[] Z = ScorePlot3DSettings.setAxes(settings.minZ, settings.maxZ, numberLines);
        settings.axisMaxX = X[0];
        settings.axisMaxY = Y[0];
        settings.axisMaxZ = Z[0];
        settings.axisMinX = X[1];
        settings.axisMinY = Y[1];
        settings.axisMinZ = Z[1];
        settings.lineSpacingX = X[2];
        settings.lineSpacingY = Y[2];
        settings.lineSpacingZ = Z[2];
        ScorePlot3DSettings.setScale(settings, scale);
    }

    public static void setAxes(ScorePlot3DSettings settings, int scale) {
        int numberLines = settings.getMaxNumberLine();
        double[] X = ScorePlot3DSettings.setAxesSquared(settings.minX, settings.maxX, numberLines);
        double[] Y = ScorePlot3DSettings.setAxesSquared(settings.minY, settings.maxY, numberLines);
        double[] Z = ScorePlot3DSettings.setAxesSquared(settings.minZ, settings.maxZ, numberLines);
        settings.axisMaxX = X[0];
        settings.axisMaxY = Y[0];
        settings.axisMaxZ = Z[0];
        settings.axisMinX = X[1];
        settings.axisMinY = Y[1];
        settings.axisMinZ = Z[1];
        settings.lineSpacingX = X[2];
        settings.lineSpacingY = Y[2];
        settings.lineSpacingZ = Z[2];
        ScorePlot3DSettings.setScale(settings, scale);
    }

    public static void setSettings(ScorePlot3DSettings settings, IResultsPCA resultsPCA) {
        int pcX = 0;
        int pcY = 1;
        int pcZ = 2;
        settings.setPcX(pcX);
        settings.setPcY(pcY);
        settings.setPcZ(pcZ);
        if (resultsPCA != null) {
            List pcaResultList = resultsPCA.getPcaResultList();
            settings.minX = ((IResultPCA)pcaResultList.stream().min((d1, d2) -> Double.compare(d1.getScoreVector()[pcX], d2.getScoreVector()[pcX])).get()).getScoreVector()[pcX];
            settings.minY = ((IResultPCA)pcaResultList.stream().min((d1, d2) -> Double.compare(d1.getScoreVector()[pcY], d2.getScoreVector()[pcY])).get()).getScoreVector()[pcY];
            settings.minZ = ((IResultPCA)pcaResultList.stream().min((d1, d2) -> Double.compare(d1.getScoreVector()[pcZ], d2.getScoreVector()[pcZ])).get()).getScoreVector()[pcZ];
            settings.maxX = ((IResultPCA)pcaResultList.stream().max((d1, d2) -> Double.compare(d1.getScoreVector()[pcX], d2.getScoreVector()[pcX])).get()).getScoreVector()[pcX];
            settings.maxY = ((IResultPCA)pcaResultList.stream().max((d1, d2) -> Double.compare(d1.getScoreVector()[pcY], d2.getScoreVector()[pcY])).get()).getScoreVector()[pcY];
            settings.maxZ = ((IResultPCA)pcaResultList.stream().max((d1, d2) -> Double.compare(d1.getScoreVector()[pcZ], d2.getScoreVector()[pcZ])).get()).getScoreVector()[pcZ];
        } else {
            settings.minX = 0.0;
            settings.minY = 0.0;
            settings.minZ = 0.0;
            settings.maxX = 0.0;
            settings.maxY = 0.0;
            settings.maxZ = 0.0;
        }
    }

    public double getAxisMaxX() {
        return this.axisMaxX;
    }

    public double getAxisMaxY() {
        return this.axisMaxY;
    }

    public double getAxisMaxZ() {
        return this.axisMaxZ;
    }

    public double getAxisMinX() {
        return this.axisMinX;
    }

    public double getAxisMinY() {
        return this.axisMinY;
    }

    public double getAxisMinZ() {
        return this.axisMinZ;
    }

    public double getAxisXlenght() {
        return Math.abs(this.axisMaxX - this.axisMinX);
    }

    public double getAxisYlenght() {
        return Math.abs(this.axisMaxY - this.axisMinY);
    }

    public double getAxisZlenght() {
        return Math.abs(this.axisMaxZ - this.axisMinZ);
    }

    public Map<String, Color> getGroup() {
        return this.groups;
    }

    public String getLabelAxisX() {
        return this.createAxisLabel(this.pcX);
    }

    public String getLabelAxisY() {
        return this.createAxisLabel(this.pcY);
    }

    public String getLabelAxisZ() {
        return this.createAxisLabel(this.pcZ);
    }

    public double getLineSpacingX() {
        return this.lineSpacingX;
    }

    public double getLineSpacingY() {
        return this.lineSpacingY;
    }

    public double getLineSpacingZ() {
        return this.lineSpacingZ;
    }

    public int getMaxNumberLine() {
        return this.maxNumberLine;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public int getPcX() {
        return this.pcX;
    }

    public int getPcY() {
        return this.pcY;
    }

    public int getPcZ() {
        return this.pcZ;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public double getShiftX() {
        return this.shiftX;
    }

    public double getShiftY() {
        return this.shiftY;
    }

    public double getShiftZ() {
        return this.shiftZ;
    }

    public void setMaxNumberLine(int maxNumberLine) {
        this.maxNumberLine = maxNumberLine;
    }

    public void setPcX(int pcX) {
        this.pcX = pcX;
    }

    public void setPcY(int pcY) {
        this.pcY = pcY;
    }

    public void setPcZ(int pcZ) {
        this.pcZ = pcZ;
    }

    private static void setScale(ScorePlot3DSettings settings, int point) {
        double maxDisX = Math.abs(settings.axisMaxX - settings.axisMinX);
        double maxDisY = Math.abs(settings.axisMaxY - settings.axisMinY);
        double maxDisZ = Math.abs(settings.axisMaxZ - settings.axisMinZ);
        settings.scaleX = (double)point / maxDisX;
        settings.scaleY = (double)point / maxDisY;
        settings.scaleZ = (double)point / maxDisZ;
        settings.shiftX = ScorePlot3DSettings.getShift(settings.axisMinX, settings.axisMaxX);
        settings.shiftY = ScorePlot3DSettings.getShift(settings.axisMinY, settings.axisMaxY);
        settings.shiftZ = ScorePlot3DSettings.getShift(settings.axisMinZ, settings.axisMaxZ);
    }

    private static double getShift(double x, double y) {
        double min = Math.min(x, y);
        double max = Math.max(x, y);
        if (min > 0.0) {
            return -(min + (max - min) / 2.0);
        }
        if (max < 0.0) {
            return -max + (-min + max) / 2.0;
        }
        if (-min < max) {
            return -(max + min) / 2.0;
        }
        return -(max + min) / 2.0;
    }

    private static double[] setAxesSquared(double x, double y, int numberLines) {
        double absMax = Math.max(Math.abs(x), Math.abs(y));
        double numberDigits = Math.floor(Math.log10(absMax));
        double round = Math.pow(10.0, numberDigits);
        double lineSpacing = (double)Math.round(absMax / round) * round / (double)numberLines;
        double maxAxis = Math.ceil(absMax / lineSpacing) * lineSpacing;
        double minAxis = Math.floor(-absMax / lineSpacing) * lineSpacing;
        return new double[]{maxAxis, minAxis, lineSpacing};
    }

    private static double[] setAxes(double x, double y, int numberLines) {
        double max = Math.max(x, y);
        double min = Math.min(x, y);
        double absMax = Math.abs(x - y);
        double numberDigits = Math.floor(Math.log10(absMax));
        double round = Math.pow(10.0, numberDigits);
        double lineSpacing = (double)Math.round(absMax / round) * round / (double)numberLines;
        double maxAxis = Math.ceil(max / (2.0 * lineSpacing)) * 2.0 * lineSpacing;
        double minAxis = Math.floor(min / (2.0 * lineSpacing)) * 2.0 * lineSpacing;
        if (maxAxis - max < lineSpacing / 2.0 || min - minAxis < lineSpacing / 2.0) {
            maxAxis += lineSpacing;
            minAxis -= lineSpacing;
        }
        return new double[]{maxAxis, minAxis, lineSpacing};
    }

    private String createAxisLabel(int componentNumber) {
        return "PC " + ++componentNumber;
    }
}

