/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.core;

import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.settings.FilterSettingsRemover;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.settings.ScanRemoverPattern;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FilterRemover
extends AbstractChromatogramFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages()) {
            try {
                if (chromatogramFilterSettings instanceof FilterSettingsRemover) {
                    FilterSettingsRemover settings = (FilterSettingsRemover)chromatogramFilterSettings;
                    ScanRemoverPattern scanRemoverPattern = new ScanRemoverPattern(settings.getScanRemoverPattern());
                    this.applyScanRemoverFilter(chromatogramSelection, scanRemoverPattern, monitor);
                    processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, "Scan Remover", "Scans have been removed successfully."));
                    processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Scans have been removed successfully."));
                    settings = (FilterSettingsRemover)chromatogramFilterSettings;
                }
            }
            catch (FilterException e) {
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage()));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        FilterSettingsRemover filterSettings = PreferenceSupplier.getRemoverFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }

    private void applyScanRemoverFilter(IChromatogramSelection chromatogramSelection, ScanRemoverPattern scanRemoverPattern, IProgressMonitor monitor) throws FilterException {
        if (chromatogramSelection != null && scanRemoverPattern != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            ArrayList<Integer> scansToRemove = new ArrayList<Integer>();
            int scan = startScan;
            while (scan <= stopScan) {
                if (scanRemoverPattern.remove()) {
                    scansToRemove.add(scan);
                }
                ++scan;
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Remove scan(s) from chromatogram", (int)scansToRemove.size());
            try {
                int removeCounter = 0;
                for (Integer scan2 : scansToRemove) {
                    scan2 = scan2 - removeCounter;
                    chromatogram.removeScan(scan2.intValue());
                    ++removeCounter;
                    subMonitor.worked(1);
                }
            }
            finally {
                SubMonitor.done((IProgressMonitor)subMonitor);
            }
            chromatogram.recalculateScanNumbers();
            chromatogramSelection.reset();
        }
    }
}

