/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.zip.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.xxd.converter.supplier.zip.internal.converter.PathHelper;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramMSDWriter {
    private static final int LEVEL = 9;
    private static final int METHOD = 8;

    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        File destinationDirectory = PathHelper.getStoragePathExport();
        File destinationFile = new File(String.valueOf(destinationDirectory.getAbsolutePath()) + File.separator + chromatogram.getName());
        IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(destinationFile, (IChromatogram)chromatogram, "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse", monitor);
        File export = (File)processingInfo.getProcessingResult();
        monitor.subTask("Compress the chromatogram");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(9);
        zipOutputStream.setMethod(8);
        ZipEntry zipEntry = new ZipEntry(export.getName());
        try (FileInputStream fileInputStream = new FileInputStream(export);){
            zipOutputStream.putNextEntry(zipEntry);
            int data = fileInputStream.read();
            while (data != -1) {
                zipOutputStream.write(data);
                data = fileInputStream.read();
            }
        }
        zipOutputStream.flush();
        zipOutputStream.close();
        export.delete();
    }
}

