/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.peak.detector.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.IPeakDetectorCSDSupport;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.PeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.settings.IPeakDetectorSettingsCSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.peak.detector.exceptions.NoPeakDetectorAvailableException;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakDetectorCSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Detector";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakDetectorCSDSupport support = PeakDetectorCSD.getPeakDetectorSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailablePeakDetectorIds()) {
                IPeakDetectorSupplier supplier = support.getPeakDetectorSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakDetectorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoPeakDetectorAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakDetectorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakDetectorSettingsCSD> {
        private IPeakDetectorSupplier supplier;

        public PeakDetectorProcessorSupplier(IPeakDetectorSupplier supplier, IProcessTypeSupplier parent) {
            super("PeakDetectorCSD." + supplier.getId(), supplier.getPeakDetectorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.CSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakDetectorSettingsCSD processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
                IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)chromatogramSelection;
                if (processSettings instanceof IPeakDetectorSettingsCSD) {
                    messageConsumer.addMessages((MessageProvider)PeakDetectorCSD.detect(chromatogramSelectionCSD, processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages((MessageProvider)PeakDetectorCSD.detect(chromatogramSelectionCSD, this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getDescription(), "Only CSD Chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

