/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.ui.icons.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.chemclipse.rcp.ui.icons.core.EmptyApplicationImageProvider;
import org.eclipse.chemclipse.rcp.ui.icons.core.IApplicationImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class IconBundle
implements IApplicationImageProvider {
    private final Bundle bundle;
    private final ImageRegistry registry = new ImageRegistry(Display.getDefault());

    public IconBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Image getImage(String fileName, String size) {
        String path = IconBundle.getPath(fileName, size);
        Image image = this.registry.get(path);
        if (image == null) {
            this.addIconImageDescriptor(path);
            return this.registry.get(path);
        }
        if (image.isDisposed()) {
            this.registry.remove(path);
            return this.getImage(fileName, size);
        }
        return image;
    }

    @Override
    public ImageDescriptor getImageDescriptor(String fileName, String size) {
        String key = IconBundle.getPath(fileName, size);
        ImageDescriptor imageDescriptor = this.registry.getDescriptor(key);
        if (imageDescriptor == null) {
            return this.addIconImageDescriptor(key);
        }
        return imageDescriptor;
    }

    private ImageDescriptor addIconImageDescriptor(String path) {
        URL entry = this.bundle.getEntry(path);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)entry);
        this.registry.put(path, imageDescriptor);
        return imageDescriptor;
    }

    @Override
    public InputStream getImageAsInputStream(String fileName, String size) throws IOException {
        URL entry = this.bundle.getEntry(IconBundle.getPath(fileName, size));
        if (entry == null) {
            return EmptyApplicationImageProvider.getInstance().getImageAsInputStream(fileName, size);
        }
        return entry.openStream();
    }

    public void dispose() {
        this.registry.dispose();
    }

    @Override
    public Collection<String> listImages(String size) {
        ArrayList<String> icons = new ArrayList<String>();
        String path = "icons/" + size + "/";
        Enumeration findEntries = this.bundle.getEntryPaths(path);
        if (findEntries != null) {
            while (findEntries.hasMoreElements()) {
                icons.add(((String)findEntries.nextElement()).substring(path.length()));
            }
        }
        return icons;
    }

    private static String getPath(String fileName, String size) {
        return "icons/" + size + "/" + fileName;
    }
}

