/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportDirectoryWizardPage
extends WizardPage {
    private static final String CONVERTER_LABEL_XY = "*.xy";
    private static final String CONVERTER_LABEL_OCB = "*.ocb";
    private static final String CONVERTER_ID_XY = "org.eclipse.chemclipse.csd.converter.supplier.xy";
    private static final String CONVERTER_ID_OCB = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse";
    private Map<String, String> converterIds = new HashMap<String, String>();
    private Combo comboConverter;
    private Text textDirectory;

    public ImportDirectoryWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.converterIds.put(CONVERTER_LABEL_XY, CONVERTER_ID_XY);
        this.converterIds.put(CONVERTER_LABEL_OCB, CONVERTER_ID_OCB);
    }

    public String getSelectedDirectory() {
        return this.textDirectory.getText().trim();
    }

    public String getSelectedConverterId() {
        return this.converterIds.get(this.comboConverter.getText().trim());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        GridData gridDataCombo = new GridData(768);
        gridDataCombo.grabExcessHorizontalSpace = true;
        gridDataCombo.horizontalSpan = 2;
        this.comboConverter = new Combo(container, 0);
        this.comboConverter.select(1);
        this.comboConverter.setItems(new String[]{CONVERTER_LABEL_XY, CONVERTER_LABEL_OCB});
        this.comboConverter.setLayoutData((Object)gridDataCombo);
        GridData gridDataText = new GridData(768);
        gridDataText.grabExcessHorizontalSpace = true;
        this.textDirectory = new Text(container, 2048);
        this.textDirectory.setLayoutData((Object)gridDataText);
        Button button = new Button(container, 0);
        button.setText("Select the output folder");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ImportDirectoryWizardPage.this.getShell());
                directoryDialog.setText("Chromatogram Import");
                directoryDialog.setMessage("Select a folder where the imported chromatograms shall be stored.");
                String directory = directoryDialog.open();
                if (directory != null) {
                    ImportDirectoryWizardPage.this.textDirectory.setText(directory);
                }
            }
        });
        this.setControl((Control)container);
    }
}

