/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.Activator;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final int MIN_NUMBER_OF_TARGETS = 1;
    public static final int MAX_NUMBER_OF_TARGETS = 100;
    public static final String MSP_EXPORT_FILE_NAME = "openchrom-unknown.msp";
    public static final String P_NIST_APPLICATION = "nistApplication";
    public static final String P_NUMBER_OF_TARGETS = "numberOfTargets";
    public static final int DEF_NUMBER_OF_TARGETS = 3;
    public static final String P_STORE_TARGETS = "storeTargets";
    public static final boolean DEF_STORE_TARGETS = true;
    public static final String P_MAC_WINE_BINARY = "macWineBinary";
    public static final String DEF_MAC_WINE_BINARY = "/Applications/Wine.app";
    public static final String P_USE_GUI_DIRECT = "useGUIDirect";
    public static final boolean DEF_USE_GUI_DIRECT = false;
    public static final boolean DEF_USE_GUI_DIRECT_MAC = true;
    public static final String P_TIMEOUT_IN_MINUTES = "timeoutInMinutes";
    public static final int DEF_TIMEOUT_IN_MINUTES = 20;
    public static final String P_SHOW_GUI_DIALOG = "showGUIDialog";
    public static final boolean DEF_SHOW_GUI_DIALOG = true;
    public static final String P_MIN_MATCH_FACTOR = "minMatchFactor";
    public static final float DEF_MIN_MATCH_FACTOR = 80.0f;
    public static final String P_MIN_REVERSE_MATCH_FACTOR = "minReverseMatchFactor";
    public static final float DEF_MIN_REVERSE_MATCH_FACTOR = 80.0f;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public static File getNistInstallationFolder() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String path = preferences.get(P_NIST_APPLICATION, "");
        if (!path.isEmpty()) {
            File filePath = new File(path);
            if (filePath.isFile()) {
                filePath.getParentFile();
            }
            if (filePath.isDirectory()) {
                File subfolder = new File(filePath, "MSSEARCH");
                if (subfolder.isDirectory()) {
                    return subfolder;
                }
                return filePath;
            }
        }
        return null;
    }

    public static IStatus validateLocation(File location) {
        if (location == null) {
            return PreferenceSupplier.error("No Program-Location configured");
        }
        if (!location.isDirectory()) {
            return PreferenceSupplier.error("Location " + location.getAbsolutePath() + " does not exits or is not a directory");
        }
        File file = PreferenceSupplier.getNistExecutable(location);
        if (!file.isFile()) {
            return PreferenceSupplier.error("Can't find nistms.exe at path " + location.getAbsolutePath() + " or it can't be accessed");
        }
        File[] libraries = PreferenceSupplier.getLibraries(location);
        if (libraries.length == 0) {
            return PreferenceSupplier.error("Can't find any libraries at path " + location.getAbsolutePath());
        }
        return Status.OK_STATUS;
    }

    public static File[] getLibraries(File location) {
        File[] files;
        if (location.isDirectory() && (files = location.listFiles(File::isDirectory)) != null) {
            return files;
        }
        return new File[0];
    }

    public static File getNistExecutable(File location) {
        File subfolder;
        File file = new File(location, "nistms.exe");
        if (!file.exists() && (subfolder = new File(location, "MSSEARCH")).isDirectory()) {
            return PreferenceSupplier.getNistExecutable(subfolder);
        }
        return file;
    }

    private static final IStatus error(String message) {
        return new Status(4, Activator.getContext().getBundle().getSymbolicName(), message);
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_MAC_WINE_BINARY, DEF_MAC_WINE_BINARY);
        defaultValues.put(P_NUMBER_OF_TARGETS, Integer.toString(3));
        defaultValues.put(P_STORE_TARGETS, Boolean.toString(true));
        if (OperatingSystemUtils.isMac()) {
            defaultValues.put(P_USE_GUI_DIRECT, Boolean.toString(true));
        } else {
            defaultValues.put(P_USE_GUI_DIRECT, Boolean.toString(false));
        }
        defaultValues.put(P_SHOW_GUI_DIALOG, Boolean.toString(true));
        defaultValues.put(P_TIMEOUT_IN_MINUTES, Integer.toString(20));
        defaultValues.put(P_MIN_MATCH_FACTOR, Float.toString(80.0f));
        defaultValues.put(P_MIN_REVERSE_MATCH_FACTOR, Float.toString(80.0f));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static PeakIdentifierSettings getPeakIdentifierSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        PeakIdentifierSettings peakIdentifierSettings = new PeakIdentifierSettings();
        peakIdentifierSettings.setNumberOfTargets(preferences.getInt(P_NUMBER_OF_TARGETS, 3));
        peakIdentifierSettings.setStoreTargets(preferences.getBoolean(P_STORE_TARGETS, true));
        peakIdentifierSettings.setTimeoutInMinutes(preferences.getInt(P_TIMEOUT_IN_MINUTES, 20));
        return peakIdentifierSettings;
    }

    public static MassSpectrumIdentifierSettings getMassSpectrumIdentifierSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        MassSpectrumIdentifierSettings massSpectrumIdentifierSettings = new MassSpectrumIdentifierSettings();
        massSpectrumIdentifierSettings.setNumberOfTargets(preferences.getInt(P_NUMBER_OF_TARGETS, 3));
        massSpectrumIdentifierSettings.setStoreTargets(preferences.getBoolean(P_STORE_TARGETS, true));
        massSpectrumIdentifierSettings.setTimeoutInMinutes(preferences.getInt(P_TIMEOUT_IN_MINUTES, 20));
        return massSpectrumIdentifierSettings;
    }

    public static String getMacWineBinary() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_MAC_WINE_BINARY, DEF_MAC_WINE_BINARY);
    }

    public static boolean isUseGUIDirect() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_USE_GUI_DIRECT, true);
    }

    public static boolean isShowGUIDialog() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_SHOW_GUI_DIALOG, true);
    }

    public static void setShowGUIDialog(boolean showGUIDialog) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        preferences.putBoolean(P_SHOW_GUI_DIALOG, showGUIDialog);
    }

    public static float getMinMatchFactor() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getFloat(P_MIN_MATCH_FACTOR, 80.0f);
    }

    public static float getMinReverseMatchFactor() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getFloat(P_MIN_REVERSE_MATCH_FACTOR, 80.0f);
    }

    public static int getNumberOfTargets() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_NUMBER_OF_TARGETS, 3);
    }

    public static boolean getStoreTargets() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_STORE_TARGETS, true);
    }

    public static int getTimeoutInMinutes() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_TIMEOUT_IN_MINUTES, 20);
    }
}

