/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.ui.runnables;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PeakIdentifierRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "MolPeak Identifier";
    private static final String IDENTIFIER_ID = "org.eclipse.chemclipse.msd.identifier.supplier.basepeak.peak";
    private IChromatogramSelectionMSD chromatogramSelection;

    public PeakIdentifierRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            IChromatogramPeakMSD peak = (IChromatogramPeakMSD)this.chromatogramSelection.getSelectedPeak();
            IProcessingInfo processingInfo = PeakIdentifierMSD.identify((IPeakMSD)peak, (String)IDENTIFIER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            if (this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                ((ChromatogramSelectionMSD)this.chromatogramSelection).update(false);
            }
        }
        finally {
            monitor.done();
        }
    }
}

