/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import java.util.ArrayList;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figureparts.PolarPoint;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper2;

public class RoundScaleTickMarks
extends Figure {
    private RoundScale scale;
    protected static final int MAJOR_LINE_WIDTH = 2;
    protected static final int MINOR_LINE_WIDTH = 1;
    public static final int MAJOR_TICK_LENGTH = 8;
    public static final int MINOR_TICK_LENGTH = 5;
    private double minorGridStepInRadians;
    private int minorTicksNumber;

    public RoundScaleTickMarks(RoundScale scale) {
        this.scale = scale;
        this.setForegroundColor(scale.getForegroundColor());
        this.scale.setMinorTickMarkStepHint(6);
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        graphics.setAntialias(1);
        ArrayList<Double> tickLabelPositions = this.scale.getScaleTickLabels().getTickLabelPositions();
        this.drawTickMarks(graphics, tickLabelPositions);
    }

    public void updateMinorTickParas() {
        if (this.scale.isDateEnabled()) {
            this.minorTicksNumber = 6;
            this.minorGridStepInRadians = this.scale.getScaleTickLabels().getGridStepInRadians() / 6.0;
            return;
        }
        if (this.scale.getScaleTickLabels().getGridStepInRadians() / 5.0 >= this.scale.convertPixelToRadians(this.scale.getMinorTickMarkStepHint())) {
            this.minorTicksNumber = 5;
            this.minorGridStepInRadians = this.scale.getScaleTickLabels().getGridStepInRadians() / 5.0;
            return;
        }
        if (this.scale.getScaleTickLabels().getGridStepInRadians() / 4.0 >= this.scale.convertPixelToRadians(this.scale.getMinorTickMarkStepHint())) {
            this.minorTicksNumber = 4;
            this.minorGridStepInRadians = this.scale.getScaleTickLabels().getGridStepInRadians() / 4.0;
            return;
        }
        this.minorTicksNumber = 2;
        this.minorGridStepInRadians = this.scale.getScaleTickLabels().getGridStepInRadians() / 2.0;
    }

    private void drawTickMarks(Graphics graphics, ArrayList<Double> tickLabelPositions) {
        this.updateMinorTickParas();
        double minRadians = this.scale.convertPixelToRadians(2);
        SingleSourceHelper2.setLineStyle_LINE_SOLID((Graphics)graphics);
        int r = this.scale.getRadius();
        if (this.scale.isLogScaleEnabled()) {
            ArrayList<Boolean> tickLabelVisibilities = this.scale.getScaleTickLabels().getTickVisibilities();
            int i = 0;
            while (i < tickLabelPositions.size()) {
                int tickLength;
                int lineWidth;
                if (tickLabelVisibilities.get(i).booleanValue()) {
                    lineWidth = 2;
                    tickLength = 8;
                } else {
                    lineWidth = 1;
                    tickLength = 5;
                }
                double theta = tickLabelPositions.get(i);
                Point startP = new PolarPoint(r, theta).toRelativePoint(this.scale.getBounds());
                Point endP = this.scale.getTickLabelSide() == AbstractScale.LabelSide.Primary ? new PolarPoint(r + tickLength, theta).toRelativePoint(this.scale.getBounds()) : new PolarPoint(r - tickLength, theta).toRelativePoint(this.scale.getBounds());
                graphics.setLineWidth(lineWidth);
                graphics.drawLine(startP, endP);
                ++i;
            }
        } else {
            int i = 0;
            while (i < tickLabelPositions.size()) {
                double theta = tickLabelPositions.get(i);
                Point startP = new PolarPoint(r, theta).toRelativePoint(this.scale.getBounds());
                Point endP = this.scale.getTickLabelSide() == AbstractScale.LabelSide.Primary ? new PolarPoint(r + 8, theta).toRelativePoint(this.scale.getBounds()) : new PolarPoint(r - 8, theta).toRelativePoint(this.scale.getBounds());
                graphics.setLineWidth(2);
                graphics.drawLine(startP, endP);
                graphics.setLineWidth(1);
                if (this.scale.isMinorTicksVisible() && i > 0) {
                    if (i == 1 && tickLabelPositions.get(0) - tickLabelPositions.get(1) < this.scale.getScaleTickLabels().getGridStepInRadians()) {
                        double t = tickLabelPositions.get(1);
                        while (tickLabelPositions.get(0) - t > this.minorGridStepInRadians + minRadians) {
                            this.drawMinorTick(graphics, r, t += this.minorGridStepInRadians);
                        }
                    } else if (i == tickLabelPositions.size() - 1 && tickLabelPositions.get(i - 1) - tickLabelPositions.get(i) < this.scale.getScaleTickLabels().getGridStepInRadians()) {
                        double t = tickLabelPositions.get(i - 1);
                        while (t - tickLabelPositions.get(i) > this.minorGridStepInRadians + minRadians) {
                            this.drawMinorTick(graphics, r, t -= this.minorGridStepInRadians);
                        }
                    } else {
                        int j = 1;
                        while (j < this.minorTicksNumber) {
                            double t = tickLabelPositions.get(i - 1) + (tickLabelPositions.get(i) - tickLabelPositions.get(i - 1)) * (double)j / (double)this.minorTicksNumber;
                            this.drawMinorTick(graphics, r, t);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.scale.isScaleLineVisible()) {
            graphics.drawArc(new Rectangle(this.bounds.x + this.bounds.width / 2 - this.scale.getRadius(), this.bounds.y + this.bounds.height / 2 - this.scale.getRadius(), this.scale.getRadius() * 2, this.scale.getRadius() * 2), (int)this.scale.getEndAngle(), (int)this.scale.getLengthInDegrees());
        }
    }

    private void drawMinorTick(Graphics graphics, int r, double t) {
        Point minorStartP = new PolarPoint(r, t).toRelativePoint(this.scale.getBounds());
        Point minorEndP = this.scale.getTickLabelSide() == AbstractScale.LabelSide.Primary ? new PolarPoint(r + 5, t).toRelativePoint(this.scale.getBounds()) : new PolarPoint(r - 5, t).toRelativePoint(this.scale.getBounds());
        graphics.drawLine(minorStartP, minorEndP);
    }
}

