/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.IVendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.VendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSLReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(MSLReader.class);
    private static final String CONVERTER_ID = "org.eclipse.chemclipse.msd.converter.supplier.amdis.massspectrum.msl";
    private static final Pattern NAME = Pattern.compile("(NAME:)(.*)", 2);
    private static final Pattern COMMENTS = Pattern.compile("(COMMENT:|COMMENTS:)(.*)", 2);
    private static final Pattern CAS = Pattern.compile("(CAS(NO|#)?:)(.*)", 2);
    private static final Pattern DB_NAME = Pattern.compile("(DB(NO|#)?:)(.*)", 2);
    private static final Pattern REFERENCE_IDENTIFIER = Pattern.compile("(REFID:)(.*)", 2);
    private static final Pattern SMILES = Pattern.compile("(SMILES:)(.*)", 2);
    private static final Pattern RETENTION_TIME = Pattern.compile("(RT:)(.*)", 2);
    private static final Pattern RELATIVE_RETENTION_TIME = Pattern.compile("(RRT:)(.*)", 2);
    private static final Pattern RETENTION_INDEX = Pattern.compile("(RI:)(.*)", 2);
    private static final Pattern DATA = Pattern.compile("(.*)(Num Peaks:)(\\s*)(\\d*)(.*)", 42);
    private static final Pattern IONS = Pattern.compile("([+]?\\d+\\.?\\d*)(\\s+)([+-]?\\d+\\.?\\d*([eE][+-]?\\d+)?)");
    private static final String CHARSET_US = "US-ASCII";
    private static final String RETENTION_INDICES_DELIMITER = ", ";
    private static final String LINE_DELIMITER = "\r\n";

    public IMassSpectra read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        List<String> massSpectraData = this.getMassSpectraData(file);
        IMassSpectra massSpectra = this.extractMassSpectra(massSpectraData);
        massSpectra.setConverterId(CONVERTER_ID);
        massSpectra.setName(file.getName());
        return massSpectra;
    }

    private List<String> getMassSpectraData(File file) throws IOException {
        Charset charset = Charset.forName(CHARSET_US);
        ArrayList<String> massSpectraData = new ArrayList<String>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() == 0) {
                    this.addMassSpectrumData(builder, massSpectraData);
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(line);
                builder.append(LINE_DELIMITER);
            }
            this.addMassSpectrumData(builder, massSpectraData);
            bufferedReader.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return massSpectraData;
    }

    private void addMassSpectrumData(StringBuilder builder, List<String> massSpectraData) {
        if (builder.length() > 0) {
            String massSpectrumData = builder.toString();
            massSpectraData.add(massSpectrumData);
        }
    }

    private IMassSpectra extractMassSpectra(List<String> massSpectraData) {
        MassSpectra massSpectra = new MassSpectra();
        String referenceIdentifierMarker = PreferenceSupplier.getReferenceIdentifierMarker();
        String referenceIdentifierPrefix = PreferenceSupplier.getReferenceIdentifierPrefix();
        for (String massSpectrumData : massSpectraData) {
            this.addMassSpectrum((IMassSpectra)massSpectra, massSpectrumData, referenceIdentifierMarker, referenceIdentifierPrefix);
        }
        return massSpectra;
    }

    private void addMassSpectrum(IMassSpectra massSpectra, String massSpectrumData, String referenceIdentifierMarker, String referenceIdentifierPrefix) {
        VendorLibraryMassSpectrum massSpectrum = new VendorLibraryMassSpectrum();
        String name = this.extractContentAsString(massSpectrumData, NAME, 2);
        this.extractNameAndReferenceIdentifier(massSpectrum, name, referenceIdentifierMarker, referenceIdentifierPrefix);
        String referenceIdentifier = String.valueOf(this.extractContentAsString(massSpectrumData, REFERENCE_IDENTIFIER, 2)) + massSpectrum.getLibraryInformation().getReferenceIdentifier();
        massSpectrum.getLibraryInformation().setReferenceIdentifier(referenceIdentifier);
        String comments = this.extractContentAsString(massSpectrumData, COMMENTS, 2);
        massSpectrum.getLibraryInformation().setComments(comments);
        String casNumber = this.extractContentAsString(massSpectrumData, CAS, 3);
        massSpectrum.getLibraryInformation().setCasNumber(casNumber);
        String database = this.extractContentAsString(massSpectrumData, DB_NAME, 3);
        massSpectrum.getLibraryInformation().setDatabase(database);
        String smiles = this.extractContentAsString(massSpectrumData, SMILES, 2);
        massSpectrum.getLibraryInformation().setSmiles(smiles);
        int retentionTime = this.extractContentAsInt(massSpectrumData, RETENTION_TIME, 2);
        massSpectrum.setRetentionTime(retentionTime);
        int relativeRetentionTime = this.extractContentAsInt(massSpectrumData, RELATIVE_RETENTION_TIME, 2);
        massSpectrum.setRelativeRetentionTime(relativeRetentionTime);
        String retentionIndices = this.extractContentAsString(massSpectrumData, RETENTION_INDEX, 2);
        this.extractRetentionIndices(massSpectrum, retentionIndices, RETENTION_INDICES_DELIMITER);
        this.extractIons(massSpectrum, massSpectrumData);
        if (massSpectrum.getNumberOfIons() > 0) {
            massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
        }
    }

    private void extractIons(IVendorLibraryMassSpectrum massSpectrum, String massSpectrumData) {
        String ionData = "";
        Matcher data = DATA.matcher(massSpectrumData);
        data.find();
        if (data.matches()) {
            ionData = data.group(5);
        }
        Ion amdisIon = null;
        Matcher ions = IONS.matcher(ionData);
        while (ions.find()) {
            try {
                double ion = Double.parseDouble(ions.group(1));
                float abundance = Float.parseFloat(ions.group(3));
                if (!(abundance > 0.0f)) continue;
                amdisIon = new Ion(ion, abundance);
                massSpectrum.addIon((IIon)amdisIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    private String extractContentAsString(String massSpectrumData, Pattern pattern, int group) {
        String content = "";
        Matcher matcher = pattern.matcher(massSpectrumData);
        if (matcher.find()) {
            content = matcher.group(group).trim();
        }
        return content.replace("\u0000", " ");
    }

    private int extractContentAsInt(String massSpectrumData, Pattern pattern, int group) {
        int content = 0;
        try {
            Matcher matcher = pattern.matcher(massSpectrumData);
            if (matcher.find()) {
                content = (int)(Double.parseDouble(matcher.group(group).trim()) * 60000.0);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return content;
    }
}

