/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.IVendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.RegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;

public abstract class AbstractWriter {
    public static final String CRLF = "\r\n";
    public static final float NORMALIZATION_BASE = 1000.0f;
    private static final Logger logger = Logger.getLogger(AbstractWriter.class);
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();
    private static final String RT = "RT: ";
    private static final String RRT = "RRT: ";
    private static final String RI = "RI: ";
    private static final String NAME = "NAME: ";
    private static final String CASNO = "CASNO: ";
    private static final String SMILES = "SMILES: ";
    private static final String COMMENTS = "COMMENTS: ";
    private static final String SOURCE = "SOURCE: ";
    private static final String NUM_PEAKS = "NUM PEAKS: ";
    private static final String FORMULA = "FORMULA: ";
    private static final String MW = "MW: ";
    private static final String DB = "DB: ";
    private static final String REFID = "REFID: ";
    private static final String SYNONYM = "Synon:";
    private static final String ISTD = "ISTD: ";
    private static final String QUANT = "QUANT: ";
    private static final String AREA = "AREA: ";
    private static final String NO_IDENTIFIER = "NO IDENTIFIER AVAILABLE";
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    protected IScanMSD getOptimizedMassSpectrum(IScanMSD massSpectrum) {
        IScanMSD optimizedMassSpectrum = this.getUnitOrHighMassResolutionCopy(massSpectrum);
        this.normalizeMassSpectrumOnDemand(optimizedMassSpectrum);
        this.removeLowIntensityIonsOnDemand(optimizedMassSpectrum);
        return optimizedMassSpectrum;
    }

    protected void removeIonsWithAnTooLowAbundance(IScanMSD normalizedMassSpectrum, float minimumAbundance) {
        ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
        for (IIon ion : normalizedMassSpectrum.getIons()) {
            if (!(ion.getAbundance() < minimumAbundance)) continue;
            ionsToRemove.add(ion);
        }
        for (IIon ion : ionsToRemove) {
            normalizedMassSpectrum.removeIon(ion);
        }
    }

    protected String getSynonyms(IScanMSD massSpectrum) {
        ILibraryMassSpectrum libraryMassSpectrum;
        Set synonyms;
        StringBuilder builder = new StringBuilder();
        if (massSpectrum instanceof ILibraryMassSpectrum && (synonyms = (libraryMassSpectrum = (ILibraryMassSpectrum)massSpectrum).getLibraryInformation().getSynonyms()).size() > 0) {
            for (String synonym : synonyms) {
                if (synonym.equals("")) continue;
                builder.append(SYNONYM);
                builder.append(synonym);
                builder.append(CRLF);
            }
        }
        return builder.toString();
    }

    protected String getNameField(IScanMSD massSpectrum, IIdentificationTarget identificationTarget) {
        String field = NAME;
        String identification = "";
        String identifier = massSpectrum.getIdentifier();
        if (identifier != null && !identifier.equals("")) {
            identification = identifier;
        } else if (identificationTarget != null) {
            identification = identificationTarget.getLibraryInformation().getName();
        }
        if (identification.equals("")) {
            identification = NO_IDENTIFIER;
        }
        return String.valueOf(field) + identification;
    }

    protected IIdentificationTarget getIdentificationTarget(IScanMSD massSpectrum) {
        IdentificationTarget identificationTarget = null;
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            try {
                identificationTarget = new IdentificationTarget(libraryMassSpectrum.getLibraryInformation(), (IComparisonResult)ComparisonResult.createNoMatchComparisonResult());
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
        } else if (massSpectrum instanceof IRegularMassSpectrum) {
            ArrayList targets = new ArrayList(massSpectrum.getTargets());
            Collections.sort(targets, this.targetExtendedComparator);
            if (targets.size() >= 1) {
                identificationTarget = (IIdentificationTarget)targets.get(0);
            }
        }
        return identificationTarget;
    }

    protected IIdentificationTarget getPeakTarget(IPeak peak) {
        IIdentificationTarget identificationTarget = null;
        ArrayList targets = new ArrayList(peak.getTargets());
        Collections.sort(targets, this.targetExtendedComparator);
        if (targets.size() >= 1) {
            identificationTarget = (IIdentificationTarget)targets.get(0);
        }
        return identificationTarget;
    }

    protected String getCasNumberField(IIdentificationTarget identificationTarget) {
        String field = CASNO;
        if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getLibraryInformation().getCasNumber();
        }
        return field;
    }

    protected String getSmilesField(IIdentificationTarget identificationTarget) {
        String field = SMILES;
        if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getLibraryInformation().getSmiles();
        }
        return field;
    }

    protected String getCommentsField(IScanMSD massSpectrum) {
        String field = COMMENTS;
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + regularMassSpectrum.getLibraryInformation().getComments();
        }
        return field;
    }

    protected String getSourceField(IScanMSD massSpectrum, IIdentificationTarget identificationTarget) {
        String field = SOURCE;
        if (massSpectrum instanceof IVendorLibraryMassSpectrum) {
            IVendorLibraryMassSpectrum amdisMassSpectrum = (IVendorLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + amdisMassSpectrum.getSource();
        } else if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getIdentifier();
        }
        return field;
    }

    protected String getRetentionTimeField(IScanMSD massSpectrum) {
        String field = RT;
        if (massSpectrum instanceof IRegularMassSpectrum) {
            IRegularMassSpectrum regularMassSpectrum = (IRegularMassSpectrum)massSpectrum;
            field = String.valueOf(field) + this.decimalFormat.format((double)regularMassSpectrum.getRetentionTime() / 60000.0);
        } else {
            field = String.valueOf(field) + this.decimalFormat.format(0.0);
        }
        return field;
    }

    protected String getRelativeRetentionTimeField(IScanMSD massSpectrum) {
        String field = RRT;
        if (massSpectrum instanceof IRegularMassSpectrum) {
            IRegularMassSpectrum regularMassSpectrum = (IRegularMassSpectrum)massSpectrum;
            field = String.valueOf(field) + this.decimalFormat.format((double)regularMassSpectrum.getRelativeRetentionTime() / 60000.0);
        } else {
            field = String.valueOf(field) + this.decimalFormat.format(0.0);
        }
        return field;
    }

    protected String getRetentionIndexField(IScanMSD massSpectrum) {
        String field = RI;
        if (massSpectrum instanceof IRegularMassSpectrum) {
            IRegularMassSpectrum regularMassSpectrum = (IRegularMassSpectrum)massSpectrum;
            field = String.valueOf(field) + this.decimalFormat.format(regularMassSpectrum.getRetentionIndex());
        } else {
            field = String.valueOf(field) + this.decimalFormat.format(0.0);
        }
        return field;
    }

    protected String getNumberOfPeaks(IScanMSD massSpectrum) {
        String field = NUM_PEAKS;
        field = String.valueOf(field) + massSpectrum.getNumberOfIons();
        return field;
    }

    protected String getFormulaField(IScanMSD massSpectrum) {
        String field = FORMULA;
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + regularMassSpectrum.getLibraryInformation().getFormula();
        }
        return field;
    }

    protected String getMWField(IScanMSD massSpectrum) {
        String field = MW;
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            field = String.valueOf(field) + regularMassSpectrum.getLibraryInformation().getMolWeight();
        }
        return field;
    }

    protected String getDBField(IIdentificationTarget identificationTarget) {
        String field = DB;
        if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getLibraryInformation().getDatabase();
        }
        return field;
    }

    protected String getReferenceIdentifierField(IIdentificationTarget identificationTarget) {
        String field = REFID;
        if (identificationTarget != null) {
            field = String.valueOf(field) + identificationTarget.getLibraryInformation().getReferenceIdentifier();
        }
        return field;
    }

    private IScanMSD getUnitOrHighMassResolutionCopy(IScanMSD massSpectrum) {
        IScanMSD optimizedMassSpectrum;
        if (PreferenceSupplier.isUseUnitMassResolution()) {
            IExtractedIonSignal extractedIonSignal = massSpectrum.getExtractedIonSignal();
            optimizedMassSpectrum = this.getMassSpectrumCopy(massSpectrum, false);
            int startIon = extractedIonSignal.getStartIon();
            int stopIon = extractedIonSignal.getStopIon();
            int ion = startIon;
            while (ion <= stopIon) {
                try {
                    optimizedMassSpectrum.addIon((IIon)new Ion((double)ion, extractedIonSignal.getAbundance(ion)));
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
                ++ion;
            }
        } else {
            optimizedMassSpectrum = this.getMassSpectrumCopy(massSpectrum, true);
        }
        return optimizedMassSpectrum;
    }

    private void normalizeMassSpectrumOnDemand(IScanMSD massSpectrum) {
        if (PreferenceSupplier.isNormalizeIntensities()) {
            massSpectrum.normalize(1000.0f);
        }
    }

    private void removeLowIntensityIonsOnDemand(IScanMSD massSpectrum) {
        if (PreferenceSupplier.isRemoveIntensitiesLowerThanOne()) {
            this.removeIonsWithAnTooLowAbundance(massSpectrum, 1.0f);
        }
    }

    private IScanMSD getMassSpectrumCopy(IScanMSD massSpectrum, boolean copyIons) {
        RegularLibraryMassSpectrum massSpectrumCopy = new RegularLibraryMassSpectrum();
        massSpectrumCopy.setRetentionTime(massSpectrum.getRetentionTime());
        massSpectrumCopy.setRelativeRetentionTime(massSpectrum.getRelativeRetentionTime());
        massSpectrumCopy.setRetentionIndex(massSpectrum.getRetentionIndex());
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum regularMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            massSpectrumCopy.setLibraryInformation(regularMassSpectrum.getLibraryInformation());
        }
        massSpectrumCopy.getTargets().addAll(massSpectrum.getTargets());
        if (copyIons) {
            for (IIon ion : massSpectrum.getIons()) {
                try {
                    massSpectrumCopy.addIon((IIon)new Ion(ion.getIon(), ion.getAbundance()));
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
        }
        return massSpectrumCopy;
    }

    protected String getIonsFormatMSL(IScanMSD massSpectrum) {
        int blockSize = 5;
        int actualPosition = 1;
        boolean exportIntensityAsInteger = PreferenceSupplier.isExportIntensitiesAsInteger();
        StringBuilder builder = new StringBuilder();
        List ions = massSpectrum.getIons();
        for (IIon ion : ions) {
            if (actualPosition > blockSize) {
                builder.append(CRLF);
                actualPosition = 1;
            }
            builder.append("(");
            builder.append(ion.getIon());
            builder.append(" ");
            if (exportIntensityAsInteger) {
                builder.append(AbstractIon.getAbundance((float)ion.getAbundance()));
            } else {
                builder.append(ion.getAbundance());
            }
            builder.append(")");
            if (actualPosition < blockSize) {
                builder.append(" ");
            }
            ++actualPosition;
        }
        return builder.toString();
    }

    protected String getIonsFormatMSP(IScanMSD massSpectrum) {
        boolean exportIntensityAsInteger = PreferenceSupplier.isExportIntensitiesAsInteger();
        StringBuilder builder = new StringBuilder();
        List ions = massSpectrum.getIons();
        for (IIon ion : ions) {
            builder.append(ion.getIon());
            builder.append(" ");
            if (exportIntensityAsInteger) {
                builder.append(AbstractIon.getAbundance((float)ion.getAbundance()));
            } else {
                builder.append(ion.getAbundance());
            }
            builder.append(";");
            builder.append(CRLF);
        }
        return builder.toString();
    }

    protected String getInternalStandards(IPeakMSD peak) {
        StringBuilder builder = new StringBuilder();
        List internalStandards = peak.getInternalStandards();
        if (internalStandards.size() > 0) {
            for (IInternalStandard internalStandard : internalStandards) {
                builder.append(ISTD);
                builder.append(internalStandard.getName());
                builder.append(" ");
                builder.append(internalStandard.getConcentration());
                builder.append(" ");
                builder.append(internalStandard.getConcentrationUnit());
                builder.append(" ");
                builder.append(internalStandard.getResponseFactor());
                builder.append(CRLF);
            }
        }
        return builder.toString();
    }

    protected String getQuantitations(IPeakMSD peak) {
        StringBuilder builder = new StringBuilder();
        List quanitationEntries = peak.getQuantitationEntries();
        if (quanitationEntries.size() > 0) {
            for (IQuantitationEntry quantitationEntry : quanitationEntries) {
                builder.append(QUANT);
                builder.append(quantitationEntry.getName());
                builder.append(" ");
                builder.append(quantitationEntry.getConcentration());
                builder.append(" ");
                builder.append(quantitationEntry.getConcentrationUnit());
                builder.append(CRLF);
            }
        }
        return builder.toString();
    }

    protected String getArea(IPeakMSD peak) {
        String field = AREA;
        field = String.valueOf(field) + this.decimalFormat.format(peak.getIntegratedArea());
        return field;
    }
}

